/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.DataViewRepositoryCustom;
import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.dataview.model.SQLParamModel;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="DataViewRepositoryCustomImpl")
public class DataViewRepositoryCustomImpl
implements DataViewRepositoryCustom {
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String SYSTEM_PARAMS_PATTERN = "\\{\\:[a-zA-Z]{1}\\w*\\}";
    private static final String HIBERNATE_DIALECT = "hibernate.dialect";
    private static final String ERROR_METADATA = "\u672a\u80fd\u83b7\u53d6\u5230\u6570\u636e\u5e93\u7c7b\u578b\u5143\u6570\u636e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ERROR_DATAVIEW = "\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String ERROR_RESULTSET = "ResultSet\u8d44\u6e90\u5f02\u5e38:";
    private static final String ERROR_SQL = "\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String ERROR_SQL_EXECUTE = "SQL\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!\u8be6\u60c5\uff1a";
    private static final String ERROR_SESSION_FACTORY = "\u672a\u80fd\u83b7\u53d6\u5230\u7b2c\u4e09\u65b9\u7684sessionFactory\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!";

    @Override
    public JSONArray executeSQLTop1(SqlAnalysis sqlAnalysis) {
        return this.executeSQL(sqlAnalysis);
    }

    @Override
    public JSONArray executeSQL(SqlAnalysis sqlAnalysis) {
        sqlAnalysis.analysis();
        Map<SQLCorrelationEnum, Object> result = sqlAnalysis.getResult();
        EntityManagerFactory emf = this.entityManager.getEntityManagerFactory();
        Map emfProperties = emf.getProperties();
        String driverType = emfProperties.get(HIBERNATE_DIALECT).toString();
        Validate.notBlank((CharSequence)driverType, (String)ERROR_METADATA, (Object[])new Object[0]);
        String sql = result.get((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        Query query = this.entityManager.createNativeQuery(sql);
        sqlAnalysis.processSQLParams(query);
        ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return JSON.parseArray((String)JSON.toJSONString((Object)list, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    @Override
    public Page<JSONObject> executeSQLPageAble(SqlAnalysis sqlAnalysis) {
        sqlAnalysis.analysis();
        Map<SQLCorrelationEnum, Object> result = sqlAnalysis.getResult();
        EntityManagerFactory emf = this.entityManager.getEntityManagerFactory();
        Map emfProperties = emf.getProperties();
        String driverType = emfProperties.get(HIBERNATE_DIALECT).toString();
        Validate.notBlank((CharSequence)driverType, (String)ERROR_METADATA, (Object[])new Object[0]);
        String sql = result.get((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        String countSql = result.getOrDefault((Object)SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, sql).toString();
        Query query = this.entityManager.createNativeQuery(sql);
        sqlAnalysis.processSQLParams(query);
        Query countQuery = this.entityManager.createNativeQuery(countSql);
        sqlAnalysis.processSQLParams(countQuery);
        ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Object o : list) {
                JSONObject json = JSON.parseObject((String)JSON.toJSONString(o, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                jsonList.add(json);
            }
        }
        long count = ((BigInteger)countQuery.getResultList().get(0)).longValue();
        return new PageImpl(jsonList, sqlAnalysis.getPageable(), count);
    }

    @Override
    public DataViewEntity executeResource(DataViewEntity dataView) {
        Validate.notNull((Object)dataView, (String)ERROR_DATAVIEW, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)ERROR_SQL, (Object[])new Object[0]);
        Session session = (Session)this.entityManager.getDelegate();
        String sourceSql = dataView.getSourceSql();
        this.replaceSysParam(dataView);
        session.doWork(connection -> {
            LinkedHashSet<DataViewFieldEntity> fields = new LinkedHashSet<DataViewFieldEntity>();
            try (Statement statement = connection.createStatement();
                 ResultSet result = statement.executeQuery(dataView.getSourceSql());){
                ResultSetMetaData metaData = result.getMetaData();
                HashSet<Object> fieldNames = new HashSet<Object>();
                Set sysParamsStrs = dataView.getSystemFilters().stream().map(DataViewSystemEntity::getParamName).collect(Collectors.toSet());
                fieldNames.addAll(sysParamsStrs);
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    DataViewFieldEntity field = new DataViewFieldEntity();
                    field.setFieldName(metaData.getColumnLabel(i));
                    Validate.isTrue((boolean)fieldNames.add(metaData.getColumnLabel(i)), (String)"\u8fd4\u56de\u5b57\u6bb5\u96c6\u6216\u4e0e\u7cfb\u7edf\u53c2\u6570\u4e2d\u542b\u6709\u76f8\u540c\u5b57\u6bb5\u540d\uff1a%s,\u8bf7\u4e3a\u5176\u53d6\u522b\u540d\uff0c\u6216\u505a\u5176\u4ed6\u8c03\u6574\u3002", (Object[])new Object[]{metaData.getColumnLabel(i)});
                    field.setFieldType(metaData.getColumnClassName(i));
                    field.setPhysical(!StringUtils.isEmpty((CharSequence)metaData.getTableName(i)));
                    field.setSchemaName(metaData.getSchemaName(i));
                    field.setTargetTable(metaData.getTableName(i));
                    field.setTargetField(metaData.getColumnName(i));
                    field.setSortIndex(i);
                    fields.add(field);
                }
                fieldNames.clear();
            }
            dataView.setFields(fields);
        });
        dataView.setSourceSql(sourceSql);
        return dataView;
    }

    @Override
    public void checkTable(String tableName) {
        Validate.notBlank((CharSequence)tableName, (String)"\u8f93\u5165\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Session session = (Session)this.entityManager.getDelegate();
        session.doWork(connection -> {
            DatabaseMetaData md = connection.getMetaData();
            try (ResultSet rs = md.getTables(null, null, tableName, null);){
                Validate.isTrue((boolean)rs.next(), (String)"\u6240\u8bbe\u7f6e\u57fa\u7840\u8868\u5728\u4e3b\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
        });
    }

    private void closeResultSet(ResultSet results) {
        try {
            results.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("SQL\u67e5\u8be2\u7ed3\u679c\u96c6\u8d44\u6e90\u5173\u95ed\u5f02\u5e38\uff01\uff01");
        }
    }

    @Override
    public JSONArray executeSQLTop1(String dataSourceCode, SqlAnalysis sqlAnalysis) {
        return this.executeSQLHandle(dataSourceCode, sqlAnalysis, 1);
    }

    @Override
    public JSONArray executeSQL(String dataSourceCode, SqlAnalysis sqlAnalysis, DataViewEntity dataView) {
        return this.executeSQLHandle(dataSourceCode, sqlAnalysis, 2);
    }

    /*
     * Exception decompiling
     */
    public JSONArray executeSQLHandle(String dataSourceCode, SqlAnalysis sqlAnalysis, Integer type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Page<JSONObject> executeSQLPageAble(String dataSourceCode, SqlAnalysis sqlAnalysis, Pageable pageable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView) {
        Validate.notNull((Object)dataView, (String)ERROR_DATAVIEW, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)ERROR_SQL, (Object[])new Object[0]);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)"\u672a\u627e\u5230\u8be5\u6570\u636e\u6e90\uff01", (Object[])new Object[0]);
        String sourceSql = dataView.getSourceSql();
        LinkedHashSet<DataViewFieldEntity> fields = new LinkedHashSet<DataViewFieldEntity>();
        DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory);
        DataViewEntity currentDataView = this.replaceSysParam(dataView);
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery(currentDataView.getSourceSql());){
            ResultSetMetaData metaData = result.getMetaData();
            HashSet<Object> fieldNames = new HashSet<Object>();
            Set sysParamsStrs = currentDataView.getSystemFilters().stream().map(DataViewSystemEntity::getParamName).collect(Collectors.toSet());
            fieldNames.addAll(sysParamsStrs);
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                DataViewFieldEntity field = new DataViewFieldEntity();
                field.setFieldName(metaData.getColumnLabel(i));
                Validate.isTrue((boolean)fieldNames.add(metaData.getColumnLabel(i)), (String)"\u8fd4\u56de\u5b57\u6bb5\u96c6\u6216\u4e0e\u7cfb\u7edf\u53c2\u6570\u4e2d\u542b\u6709\u76f8\u540c\u5b57\u6bb5\u540d\uff1a%s,\u8bf7\u4e3a\u5176\u53d6\u522b\u540d\uff0c\u6216\u505a\u5176\u4ed6\u8c03\u6574\u3002", (Object[])new Object[]{metaData.getColumnLabel(i)});
                field.setFieldType(metaData.getColumnClassName(i));
                field.setPhysical(!StringUtils.isEmpty((CharSequence)metaData.getTableName(i)));
                field.setSchemaName(metaData.getSchemaName(i));
                field.setTargetTable(metaData.getTableName(i));
                field.setTargetField(metaData.getColumnName(i));
                field.setSortIndex(i);
                fields.add(field);
            }
            fieldNames.clear();
            currentDataView.setFields(fields);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(ERROR_SQL_EXECUTE + e.getMessage());
        }
        currentDataView.setSourceSql(sourceSql);
        return currentDataView;
    }

    @Override
    public void checkTable(String dataSourceCode, String tableName) {
        Validate.notBlank((CharSequence)tableName, (String)"\u8f93\u5165\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u8f93\u5165\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        try (Connection connection = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory).getConnection();){
            DatabaseMetaData md = connection.getMetaData();
            try (ResultSet rs = md.getTables(null, null, tableName, null);){
                Validate.isTrue((boolean)rs.next(), (String)"\u6240\u8bbe\u7f6e\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4e2d\u57fa\u7840\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_SQL_EXECUTE + e.getMessage());
        }
    }

    private DataViewEntity replaceSysParam(DataViewEntity dataView) {
        Validate.notNull((Object)dataView, (String)ERROR_DATAVIEW, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)ERROR_SQL, (Object[])new Object[0]);
        String sql = dataView.getSourceSql();
        LinkedHashSet<DataViewSystemEntity> systemEntities = new LinkedHashSet<DataViewSystemEntity>();
        Set<String> sysParams = this.extractMessageByRegular(sql);
        if (!CollectionUtils.isEmpty(sysParams)) {
            for (String param : sysParams) {
                DataViewSystemEntity dataViewSystem = new DataViewSystemEntity();
                dataViewSystem.setParamName(param);
                systemEntities.add(dataViewSystem);
                String replaceStr = "{:" + param + "}";
                sql = sql.replace(replaceStr, "('')");
            }
        }
        dataView.setSystemFilters(systemEntities);
        dataView.setSourceSql(sql);
        return dataView;
    }

    private Set<String> extractMessageByRegular(String msg) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern p = Pattern.compile(SYSTEM_PARAMS_PATTERN);
        Matcher m = p.matcher(msg);
        while (m.find()) {
            list.add(m.group().substring(2, m.group().length() - 1));
        }
        return list;
    }

    private int processCountResultSet(PreparedStatement st) {
        int count = 0;
        try (ResultSet results = st.executeQuery();){
            if (results.next()) {
                count = results.getInt(1);
            }
            this.closeResultSet(results);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("CountResultSet\u8d44\u6e90\u5f02\u5e38:" + e.getMessage());
        }
        return count;
    }

    private Page<JSONObject> processResultSet(PreparedStatement st, Pageable pageable, int count) {
        PageImpl page;
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        try (ResultSet results = st.executeQuery();){
            while (results.next()) {
                ResultSetMetaData meta = results.getMetaData();
                JSONObject jsonObj = new JSONObject();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    jsonObj.put(meta.getColumnLabel(i), results.getObject(i));
                }
                list.add(jsonObj);
            }
            page = new PageImpl(list, pageable, (long)count);
            this.closeResultSet(results);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_RESULTSET + e.getMessage());
        }
        return page;
    }

    /*
     * Unable to fully structure code
     */
    private JSONArray processResultSet(PreparedStatement st, Integer type) {
        jsonArr = new JSONArray();
        switch (type) {
            case 1: {
                try {
                    results = st.executeQuery();
                    var5_8 = null;
                    if (results.first()) {
                        meta = results.getMetaData();
                        jsonObj = new JSONObject();
                        for (i = 1; i <= meta.getColumnCount(); ++i) {
                            jsonObj.put(meta.getColumnLabel(i), results.getObject(i));
                        }
                        jsonArr.add((Object)jsonObj);
                    }
                    if (results == null) break;
                    if (var5_8 == null) ** GOTO lbl25
                    try {
                        results.close();
                    }
                    catch (Throwable meta) {
                        var5_8.addSuppressed(meta);
                    }
                    break;
lbl25:
                    // 1 sources

                    results.close();
                    ** break;
                    catch (Throwable meta) {
                        try {
                            var5_8 = meta;
                            throw meta;
                        }
                        catch (Throwable var9_20) {
                            if (results != null) {
                                if (var5_8 != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (Throwable var10_21) {
                                        var5_8.addSuppressed(var10_21);
                                    }
                                } else {
                                    results.close();
                                }
                            }
                            throw var9_20;
lbl42:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("ResultSet\u8d44\u6e90\u5f02\u5e38:" + e.getMessage());
                }
            }
            case 2: {
                try {
                    results = st.executeQuery();
                    var5_9 = null;
                    while (results.next()) {
                        meta = results.getMetaData();
                        jsonObj = new JSONObject();
                        for (i = 1; i <= meta.getColumnCount(); ++i) {
                            jsonObj.put(meta.getColumnLabel(i), results.getObject(i));
                        }
                        jsonArr.add((Object)jsonObj);
                    }
                    if (results == null) break;
                    if (var5_9 == null) ** GOTO lbl68
                    try {
                        results.close();
                    }
                    catch (Throwable var6_14) {
                        var5_9.addSuppressed(var6_14);
                    }
                    break;
lbl68:
                    // 1 sources

                    results.close();
                    ** break;
                    catch (Throwable var6_15) {
                        try {
                            var5_9 = var6_15;
                            throw var6_15;
                        }
                        catch (Throwable var11_22) {
                            if (results != null) {
                                if (var5_9 != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (Throwable var12_23) {
                                        var5_9.addSuppressed(var12_23);
                                    }
                                } else {
                                    results.close();
                                }
                            }
                            throw var11_22;
lbl85:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("ResultSet\u8d44\u6e90\u5f02\u5e38:" + e.getMessage());
                }
            }
        }
        return jsonArr;
    }

    @Override
    public JSONArray executeSQLEcho(DataViewEntity dataView, InvokeParams invokeParams, Map<String, Object> presets, String primaryKey, JSONArray primaryValue) {
        String sql = dataView.getSourceSql();
        Validate.notBlank((CharSequence)sql, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56feSQL\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)primaryKey, (String)"\u4f20\u5165\u7684primaryKey\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)primaryValue, (String)"\u4f20\u5165\u7684primaryValue\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (primaryValue.isEmpty()) {
            return new JSONArray();
        }
        DataSourceEntity dataSource = dataView.getDataSource();
        Set<DataViewFieldEntity> fields = dataView.getFields();
        Validate.isTrue((!CollectionUtils.isEmpty(fields) ? 1 : 0) != 0, (String)"\u89c6\u56fe\u4fe1\u606f\u4e2d\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u7684\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String sourceSQL = dataView.getSourceSql();
        Set<DataViewSystemEntity> systemFilters = dataView.getSystemFilters();
        Pattern pattern = Pattern.compile(SYSTEM_PARAMS_PATTERN);
        Integer count = 1;
        ArrayList<SQLParamModel> values = new ArrayList<SQLParamModel>();
        if (!CollectionUtils.isEmpty(systemFilters)) {
            for (int i = 0; i < systemFilters.size(); ++i) {
                Matcher m = pattern.matcher(sourceSQL);
                String re = null;
                if (m.find()) {
                    re = m.group().substring(2, m.group().length() - 1);
                }
                Validate.notBlank(re, (String)"\u6839\u636e\u6b63\u5219\u8868\u8fbe\u5f0f\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u7cfb\u7edf\u53c2\u6570\u4fe1\u606f", (Object[])new Object[0]);
                String systemParamName = re;
                Optional<DataViewSystemEntity> op = systemFilters.stream().filter(e -> StringUtils.equals((CharSequence)e.getParamName(), (CharSequence)systemParamName)).findFirst();
                DataViewSystemEntity systemEntity = op.orElse(null);
                Validate.notNull((Object)systemEntity, (String)"\u505a\u7cfb\u7edf\u53c2\u6570\u5206\u6790\u65f6\uff0c\u672a\u80fd\u67e5\u8be2\u5230\u7cfb\u7edf\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
                Validate.isTrue((systemEntity.getParamSourceType() != null ? 1 : 0) != 0, (String)"\u505a\u7cfb\u7edf\u53c2\u6570\u5206\u6790\u65f6\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u53c2\u6570\u6765\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
                String searchStr = "\\{\\:" + re + "\\}";
                String replacement = "?";
                if (dataSource == null) {
                    replacement = replacement + count;
                }
                switch (systemEntity.getParamSourceType()) {
                    case 1: {
                        InvokeOperations model = invokeParams.get(systemParamName);
                        Validate.notNull((Object)model, (String)"\u5916\u90e8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                        Object compareValue = model.getCompareValue();
                        Validate.notNull((Object)compareValue, (String)"\u5916\u90e8\u4f20\u5165\u7684\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                        sourceSQL = RegExUtils.replaceFirst((String)sourceSQL, (String)searchStr, (String)replacement);
                        SQLParamModel paramModel = new SQLParamModel();
                        paramModel.setValue(compareValue);
                        paramModel.setParamName(systemEntity.getParamName());
                        paramModel.setParamType(systemEntity.getParamType());
                        paramModel.setTransferType(1);
                        paramModel.setMappingType(model.getMappingType());
                        paramModel.setIndex(count);
                        values.add(paramModel);
                        break;
                    }
                    case 2: {
                        sourceSQL = RegExUtils.replaceFirst((String)sourceSQL, (String)searchStr, (String)replacement);
                        SQLParamModel paramModel2 = new SQLParamModel();
                        paramModel2.setValue(systemEntity.getParamValue());
                        paramModel2.setParamName(systemEntity.getParamName());
                        paramModel2.setParamType(systemEntity.getParamType());
                        paramModel2.setTransferType(2);
                        paramModel2.setMappingType(systemEntity.getParamType());
                        paramModel2.setIndex(count);
                        values.add(paramModel2);
                        break;
                    }
                    case 3: {
                        sourceSQL = RegExUtils.replaceFirst((String)sourceSQL, (String)searchStr, (String)replacement);
                        SQLParamModel paramModel3 = new SQLParamModel();
                        paramModel3.setValue(presets.get(systemEntity.getParamName() + "|DataViewSystemEntity"));
                        paramModel3.setParamName(systemEntity.getParamName());
                        paramModel3.setParamKey(systemEntity.getParamKey());
                        paramModel3.setTransferType(3);
                        paramModel3.setSource(DataViewSystemEntity.class);
                        paramModel3.setIndex(count);
                        values.add(paramModel3);
                        break;
                    }
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
        }
        StringBuilder executeSQL = new StringBuilder("select * from (" + sourceSQL + ") tb where 1=1 ");
        executeSQL.append(" and ").append(primaryKey).append(" in (");
        for (int index = 0; index < primaryValue.size(); ++index) {
            String o = primaryValue.getString(index);
            executeSQL.append("?");
            if (dataSource == null) {
                executeSQL.append(count);
            }
            executeSQL.append(",");
            SQLParamModel model = new SQLParamModel();
            model.setValue(o);
            model.setParamName(primaryKey);
            model.setTransferType(2);
            model.setSource(DataViewSystemEntity.class);
            Integer n = count;
            Integer n3 = count = Integer.valueOf(count + 1);
            model.setIndex(n);
            values.add(model);
        }
        executeSQL.replace(executeSQL.toString().length() - 1, executeSQL.toString().length(), "");
        executeSQL.append(") ");
        JSONArray jsonArr = dataSource == null ? this.executeSQLEcho(executeSQL.toString(), values) : this.executeSQLEcho(dataSource.getCode(), executeSQL.toString(), values);
        return jsonArr;
    }

    @Override
    public JSONArray executeSQLEcho(String sql, List<SQLParamModel> models) {
        EntityManagerFactory emf = this.entityManager.getEntityManagerFactory();
        Map emfProperties = emf.getProperties();
        String driverType = emfProperties.get(HIBERNATE_DIALECT).toString();
        Validate.notBlank((CharSequence)driverType, (String)ERROR_METADATA, (Object[])new Object[0]);
        Query query = this.entityManager.createNativeQuery(sql);
        for (SQLParamModel model : models) {
            AbstractSqlAnalysis.matchJPAParamType(query, model.getValue(), model);
        }
        ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return JSON.parseArray((String)JSON.toJSONString((Object)list, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    /*
     * Exception decompiling
     */
    @Override
    public JSONArray executeSQLEcho(String dataSourceCode, String sql, List<SQLParamModel> models) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

