/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class OracleSqlAnalysis
extends AbstractSqlAnalysis {
    public OracleSqlAnalysis(DataViewEntity dataView, Set<DataViewFilterEntity> filters, Set<DataViewSystemEntity> systemParams, Set<DataViewAuthHorizontalEntity> authHorizontals, Set<DataViewAuthVerticalEntity> authVerticals, InvokeParams params, Pageable pageable, Set<DataViewFieldEntity> allFileds, DataViewAuthInterceptorEntity dataViewAuthInterceptor) {
        super(dataView, filters, systemParams, authHorizontals, authVerticals, params, pageable, allFileds, dataViewAuthInterceptor);
    }

    @Override
    public void analysis() {
        super.analysis();
        this.pageAnalysis();
    }

    private void pageAnalysis() {
        if (this.pageable == null || CollectionUtils.isEmpty((Map)this.result)) {
            return;
        }
        String prePageSQL = this.result.remove((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        String countSQL = String.format("select count(*) from (%s) a", prePageSQL);
        this.result.put(SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, countSQL);
        int start = this.pageable.getPageNumber() * this.pageable.getPageSize();
        int end = (this.pageable.getPageNumber() + 1) * this.pageable.getPageSize();
        String pageSQL = String.format("select * from (select %s.*,ROWNUM RN from (%s) %s where ROWNUM <= %d) %s where RN > %d", "s02y02s02", prePageSQL, "s02y02s02", end, "s03y03s03", start);
        this.result.put(SQLCorrelationEnum.RESULT_SQL, pageSQL);
    }

    @Override
    public String concatSql(String ... strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        return StringUtils.join((Object[])strs, (String)"||");
    }
}

