/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthVerticalRelationRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalRelationService;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthVerticalRelationServiceImpl")
public class DataViewAuthVerticalRelationServiceImpl
implements DataViewAuthVerticalRelationService {
    @Autowired
    private DataViewAuthVerticalRelationRepository dataViewAuthVerticalRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(DataViewAuthVerticalEntity dataViewAuthVerticalEntity, Set<DataViewAuthVerticalRelationEntity> authRelations) {
        Validate.notNull((Object)dataViewAuthVerticalEntity, (String)"\u7eb5\u5411\u6570\u636e\u6743\u9650\u7684\u5bf9\u8c61\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        authRelations.stream().forEach(x -> x.setAuthVertical(dataViewAuthVerticalEntity));
        authRelations.forEach(x -> this.createValidation((DataViewAuthVerticalRelationEntity)x));
        this.dataViewAuthVerticalRelationRepository.saveAll(authRelations);
    }

    @Override
    public void createValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity) {
        Validate.notNull((Object)dataViewAuthVerticalRelationEntity, (String)"\u6743\u9650\u9886\u57df\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewAuthVerticalRelationEntity.getId()), (String)"\u6dfb\u52a0\u6743\u9650\u9886\u57df\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewAuthVerticalRelationEntity.setId(null);
        DataViewAuthVerticalEntity authVertical = dataViewAuthVerticalRelationEntity.getAuthVertical();
        Validate.notNull((Object)authVertical, (String)"\u4f20\u5165\u7684\u7eb5\u5411\u6743\u9650\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthVerticalRelationEntity.getAuthRelationIds(), (String)"\u6743\u9650\u9886\u57df\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalRelationEntity.getSortIndex(), (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthVerticalRelationEntity.getAuthRelationIds() == null || dataViewAuthVerticalRelationEntity.getAuthRelationIds().length() < 255 ? 1 : 0) != 0, (String)"\u6743\u9650\u5173\u7cfb\u96c6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public void updateValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewAuthVerticalRelationEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6743\u9650\u9886\u57df\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        DataViewAuthVerticalEntity authVertical = dataViewAuthVerticalRelationEntity.getAuthVertical();
        Validate.notNull((Object)authVertical, (String)"\u4f20\u5165\u7684\u7eb5\u5411\u6743\u9650\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthVerticalRelationEntity.getAuthRelationIds(), (String)"\u6743\u9650\u9886\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalRelationEntity.getSortIndex(), (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthVerticalRelationEntity.getAuthRelationIds() == null || dataViewAuthVerticalRelationEntity.getAuthRelationIds().length() < 255 ? 1 : 0) != 0, (String)"\u6743\u9650\u5173\u7cfb\u96c6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<DataViewAuthVerticalRelationEntity> findDetailsByAuthVertical(String authVertical) {
        if (StringUtils.isBlank((CharSequence)authVertical)) {
            return Sets.newHashSet();
        }
        return this.dataViewAuthVerticalRelationRepository.findDetailsByAuthVertical(authVertical);
    }

    @Override
    public DataViewAuthVerticalRelationEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthVerticalRelationRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthVerticalRelationEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewAuthVerticalRelationRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewAuthVerticalRelationRepository.findById(id);
        op.ifPresent(dataViewAuthVerticalRelationEntity -> this.dataViewAuthVerticalRelationRepository.delete(dataViewAuthVerticalRelationEntity));
    }

    @Override
    @Transactional
    public void deleteByAuthVertical(String authVerticalId) {
        Validate.notBlank((CharSequence)authVerticalId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u7eb5\u5411\u6570\u636e\u6743\u9650\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        this.dataViewAuthVerticalRelationRepository.deleteByAuthVertical(authVerticalId);
    }

    @Override
    @Transactional
    public Set<DataViewAuthVerticalRelationEntity> save(DataViewAuthVerticalEntity authVertical, Set<DataViewAuthVerticalRelationEntity> authRelations) {
        Set<DataViewAuthVerticalRelationEntity> dbAuthVerticalRelations;
        Set<String> needDeleteAuthVerticalRelationKeys;
        Set<DataViewAuthVerticalRelationEntity> needUpdateAuthRelations;
        HashSet<DataViewAuthVerticalRelationEntity> relations = new HashSet<DataViewAuthVerticalRelationEntity>();
        Set<DataViewAuthVerticalRelationEntity> needInsertAuthRelations = authRelations.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getId())).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(needInsertAuthRelations)) {
            needInsertAuthRelations.forEach(y -> {
                y.setAuthVertical(authVertical);
                this.createValidation((DataViewAuthVerticalRelationEntity)y);
            });
            this.dataViewAuthVerticalRelationRepository.saveAll(needInsertAuthRelations);
            relations.addAll(needInsertAuthRelations);
        }
        if (!CollectionUtils.isEmpty(needUpdateAuthRelations = authRelations.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getId())).collect(Collectors.toSet()))) {
            needUpdateAuthRelations.forEach(y -> {
                y.setAuthVertical(authVertical);
                this.updateValidation((DataViewAuthVerticalRelationEntity)y);
            });
            this.dataViewAuthVerticalRelationRepository.saveAll(needUpdateAuthRelations);
            relations.addAll(needUpdateAuthRelations);
        }
        if (!CollectionUtils.isEmpty(needDeleteAuthVerticalRelationKeys = this.nebulaToolkitService.collectionDiffent(dbAuthVerticalRelations = this.dataViewAuthVerticalRelationRepository.findDetailsByAuthVertical(authVertical.getId()), authRelations, UuidEntity::getId))) {
            needDeleteAuthVerticalRelationKeys.forEach(x -> this.dataViewAuthVerticalRelationRepository.deleteById(x));
        }
        return relations;
    }
}

