/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewFilterRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataViewFilterService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewFilterEntityServiceImpl")
public class DataViewFilterServiceImpl
implements DataViewFilterService {
    @Autowired
    private DataViewFilterRepository dataViewFilterEntityRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void createValidation(DataViewFilterEntity dataViewFilterEntity) {
        Validate.notNull((Object)dataViewFilterEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewFilterEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewFilterEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getOpType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getNullable(), (String)"\u662f\u5426\u53ef\u4ee5\u4e0d\u8fdb\u884c\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getOpType() == null || dataViewFilterEntity.getOpType().length() < 255 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getDisplayName() == null || dataViewFilterEntity.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataViewFilterEntity create(DataViewFilterEntity dataViewFilterEntity, boolean ignoreValidate) {
        if (!ignoreValidate) {
            this.createValidation(dataViewFilterEntity);
        }
        this.dataViewFilterEntityRepository.save(dataViewFilterEntity);
        return dataViewFilterEntity;
    }

    @Override
    @Transactional
    public DataViewFilterEntity update(DataViewFilterEntity dataViewFilterEntity) {
        this.updateValidation(dataViewFilterEntity);
        String currentId = dataViewFilterEntity.getId();
        Optional op = this.dataViewFilterEntityRepository.findById(currentId);
        DataViewFilterEntity currentDataViewFilterEntity = op.orElse(null);
        Validate.notNull((Object)currentDataViewFilterEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        currentDataViewFilterEntity.setOpType(dataViewFilterEntity.getOpType());
        currentDataViewFilterEntity.setSortIndex(dataViewFilterEntity.getSortIndex());
        currentDataViewFilterEntity.setNullable(dataViewFilterEntity.getNullable());
        currentDataViewFilterEntity.setDisplayName(dataViewFilterEntity.getDisplayName());
        this.dataViewFilterEntityRepository.save(currentDataViewFilterEntity);
        return currentDataViewFilterEntity;
    }

    @Override
    public void updateValidation(DataViewFilterEntity dataViewFilterEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewFilterEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getOpType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getNullable(), (String)"\u662f\u5426\u53ef\u4ee5\u4e0d\u8fdb\u884c\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getOpType() == null || dataViewFilterEntity.getOpType().length() < 255 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getDisplayName() == null || dataViewFilterEntity.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<DataViewFilterEntity> findByDataView(String dataViewId) {
        if (StringUtils.isBlank((CharSequence)dataViewId)) {
            return Lists.newArrayList();
        }
        return this.dataViewFilterEntityRepository.findByDataView(dataViewId);
    }

    @Override
    public List<DataViewFilterEntity> findByField(String fieldId) {
        if (StringUtils.isBlank((CharSequence)fieldId)) {
            return Lists.newArrayList();
        }
        return this.dataViewFilterEntityRepository.findByField(fieldId);
    }

    @Override
    public DataViewFilterEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewFilterEntityRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewFilterEntityRepository.findById(id);
        op.ifPresent(dataViewFilterEntity -> this.dataViewFilterEntityRepository.delete(dataViewFilterEntity));
    }

    @Override
    @Transactional
    public void deleteByField(String fieldId) {
        Validate.notBlank((CharSequence)fieldId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9aField\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        List<DataViewFilterEntity> filters = this.dataViewFilterEntityRepository.findByField(fieldId);
        if (!CollectionUtils.isEmpty(filters)) {
            for (DataViewFilterEntity filter : filters) {
                this.dataViewFilterEntityRepository.deleteById(filter.getId());
            }
        }
    }

    @Override
    @Transactional
    public void create(Set<DataViewFilterEntity> filters, Set<DataViewFieldEntity> fields, DataViewEntity dataViewEntity) {
        Validate.notNull((Object)dataViewEntity, (String)"\u6570\u636e\u89c6\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(filters)) {
            for (DataViewFilterEntity filter2 : filters) {
                this.createValidation(filter2);
                filter2.setDataView(dataViewEntity);
            }
        }
        if (filters != null) {
            filters.forEach(filter -> {
                Optional<DataViewFieldEntity> optional = fields.stream().filter(field -> StringUtils.equals((CharSequence)field.getFieldName(), (CharSequence)filter.getField().getFieldName())).findFirst();
                Validate.isTrue((boolean)optional.isPresent(), (String)"\u8fc7\u6ee4\u5b57\u6bb5\u4e2d\uff0c\u672a\u53d1\u73b0\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                filter.setField(optional.get());
            });
            this.dataViewFilterEntityRepository.saveAll(filters);
        }
    }

    @Override
    @Transactional
    public Set<DataViewFilterEntity> update(DataViewEntity dataView, Set<DataViewFilterEntity> filters) {
        Validate.notNull((Object)dataView, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getId(), (String)"\u6570\u636e\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.updateValidation(filters);
        if (filters == null) {
            filters = Sets.newHashSet();
        }
        Map<String, DataViewFieldEntity> fields = dataView.getFields().stream().collect(Collectors.toMap(DataViewFieldEntity::getFieldName, v -> v));
        List<DataViewFilterEntity> dbFilters = this.dataViewFilterEntityRepository.findByDataView(dataView.getId());
        Map<String, DataViewFilterEntity> filterMap = filters.stream().collect(Collectors.toMap(UuidEntity::getId, v -> v, (v1, v2) -> v1));
        HashSet<DataViewFilterEntity> createFilters = new HashSet<DataViewFilterEntity>();
        HashSet updateFilters = new HashSet();
        HashSet deleteFilters = new HashSet();
        this.nebulaToolkitService.collectionDiscrepancy(filters, dbFilters, UuidEntity::getId, deleteFilters, updateFilters, createFilters);
        for (DataViewFilterEntity filter : createFilters) {
            DataViewFieldEntity field = fields.get(filter.getField().getFieldName());
            Validate.notNull((Object)field, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a%s", (Object[])new Object[]{filter.getField().getFieldName()});
            filter.setField(field);
            filter.setDataView(dataView);
            this.dataViewFilterEntityRepository.save(filter);
        }
        for (DataViewFilterEntity filter : updateFilters) {
            DataViewFilterEntity updateFilter = filterMap.get(filter.getId());
            DataViewFieldEntity field = fields.get(updateFilter.getField().getFieldName());
            Validate.notNull((Object)field, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a%s", (Object[])new Object[]{updateFilter.getField().getFieldName()});
            filter.setField(field);
            filter.setDisplayName(updateFilter.getDisplayName());
            filter.setNullable(updateFilter.getNullable());
            filter.setOpType(updateFilter.getOpType());
            filter.setSortIndex(updateFilter.getSortIndex());
            this.dataViewFilterEntityRepository.save(filter);
        }
        this.dataViewFilterEntityRepository.deleteAll(deleteFilters);
        createFilters.addAll(updateFilters);
        return createFilters;
    }

    private void updateValidation(Set<DataViewFilterEntity> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return;
        }
        for (DataViewFilterEntity filter : filters) {
            Validate.notBlank((CharSequence)filter.getOpType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)filter.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)filter.getNullable(), (String)"\u662f\u5426\u53ef\u4ee5\u4e0d\u8fdb\u884c\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)filter.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)filter.getField(), (String)"\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)filter.getField().getFieldName(), (String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((filter.getOpType() == null || filter.getOpType().length() < 255 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((filter.getDisplayName() == null || filter.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
    }
}

