/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.file;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class NebulaFileServiceSimpleImpl
implements NebulaFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaFileServiceSimpleImpl.class);
    @Value(value="${nebula.file.fileRoot}")
    private String fileRoot;
    @Value(value="${nebula.file.maxFileSize}")
    private Integer maxFileSize;
    @Value(value="${nebula.file.whitePrefixs}")
    private String[] whitePrefixs;

    @Override
    public void saveFile(String relativePath, String fileName, String fileRename, byte[] fileContext) {
        long fileSize = fileContext.length;
        LOGGER.debug("====fiel Upload====originalFilename:{},fileSize:{}", (Object)fileName, (Object)fileSize);
        Validate.isTrue((fileSize < (long)(this.maxFileSize * 1024 * 1024) ? 1 : 0) != 0, (String)"image file should be less than %dMB!", (long)this.maxFileSize.intValue());
        if (!StringUtils.isBlank((CharSequence)relativePath)) {
            Validate.matchesPattern((CharSequence)relativePath, (String)"/{1}[a-z|A-Z|0-9|_|/|\\.]+", (String)"relativePath must begin with chartset '/' or relativePath noncompliance !!", (Object[])new Object[0]);
        }
        int nodeIndex = StringUtils.lastIndexOf((CharSequence)fileName, (CharSequence)".");
        String filePrefix = StringUtils.substring((String)fileName, (int)(nodeIndex + 1), (int)fileName.length());
        HashSet whitePrefixSet = Sets.newHashSet((Object[])this.whitePrefixs);
        whitePrefixSet.add("txt");
        Validate.isTrue((boolean)whitePrefixSet.stream().anyMatch(item -> StringUtils.equalsAnyIgnoreCase((CharSequence)item, (CharSequence[])new CharSequence[]{filePrefix})), (String)"file prefix[%s] is not allow", (Object[])new Object[]{fileName});
        String absoluteDirPath = StringUtils.join((Object[])new String[]{this.fileRoot, relativePath});
        File absoluteDirPathFile = new File(absoluteDirPath);
        if (!absoluteDirPathFile.exists()) {
            Validate.isTrue((boolean)absoluteDirPathFile.mkdirs(), (String)"\u65e0\u6cd5\u521b\u5efa\u6307\u5b9a\u7684\u6587\u4ef6\u5939\uff0c\u56e0\u4e3a\u6ca1\u6709\u64cd\u4f5c\u6743\u9650[%s]\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5b58\u50a8\u7684\u64cd\u4f5c\u76ee\u5f55\u7684\u6743\u9650!", (Object[])new Object[]{absoluteDirPath});
        }
        String fullPath = StringUtils.join((Object[])new String[]{absoluteDirPath, "/", fileRename});
        try (FileOutputStream fileOut = new FileOutputStream(new File(fullPath));
             ByteArrayInputStream byteIn = new ByteArrayInputStream(fileContext);){
            int realen;
            int maxLen = 204800;
            byte[] readContext = new byte[maxLen];
            while ((realen = byteIn.read(readContext, 0, maxLen)) != -1) {
                fileOut.write(readContext, 0, realen);
            }
        }
        catch (IOException | IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void deleteFile(String relativePath, String fileName, String fileRename) {
        if (!StringUtils.isBlank((CharSequence)relativePath)) {
            Validate.matchesPattern((CharSequence)relativePath, (String)"/{1}[a-z|A-Z|0-9|_|/|\\.]+", (String)"relativePath must begin with chartset '/' or relativePath noncompliance !!", (Object[])new Object[0]);
        }
        String absoluteDirPath = StringUtils.join((Object[])new String[]{this.fileRoot, relativePath});
        String fullPath = StringUtils.join((Object[])new String[]{absoluteDirPath, "/", fileRename});
        File fullPathFile = new File(fullPath);
        if (fullPathFile.exists()) {
            Validate.isTrue((boolean)fullPathFile.delete(), (String)"\u65e0\u6cd5\u5220\u9664\u6587\u4ef6\uff0c\u56e0\u4e3a\u6ca1\u6709\u64cd\u4f5c\u6743\u9650[%s]\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5b58\u50a8\u7684\u64cd\u4f5c\u76ee\u5f55\u7684\u6743\u9650", (Object[])new Object[]{fullPath});
        }
    }

    @Override
    public byte[] readFileContent(String relativePath, String fileRename) {
        String absoluteDirPath = StringUtils.join((Object[])new String[]{this.fileRoot, relativePath});
        String fullPath = StringUtils.join((Object[])new String[]{absoluteDirPath, "/", fileRename});
        File fullPathFile = new File(fullPath);
        if (!fullPathFile.exists()) {
            return new byte[0];
        }
        if (!fullPathFile.isFile()) {
            return new byte[0];
        }
        byte[] fileContents = null;
        try (FileInputStream ois = new FileInputStream(fullPathFile);
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int realen;
            int maxLen = 204800;
            byte[] readContext = new byte[maxLen];
            while ((realen = ois.read(readContext, 0, maxLen)) != -1) {
                out.write(readContext, 0, realen);
            }
            fileContents = out.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return fileContents;
    }
}

