/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.image;

import com.bizunited.platform.core.service.image.CutImageHandler;
import com.bizunited.platform.core.service.image.ImageHandler;
import com.bizunited.platform.core.service.image.MarkStringImageHandler;
import com.bizunited.platform.core.service.image.ZoomImageHandler;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class ImageHandlerBuilder {
    private static final String MESS_IMAGEHANDLER_CUT_CLASS_NAME = "yinwenjie.sample.image.service.CutImageHandler";
    private static final String MESS_IMAGEHANDLER_ZOOM_CLASS_NAME = "yinwenjie.sample.image.service.ZoomImageHandler";

    private ImageHandlerBuilder() {
    }

    private static class ImageHandlerDescribe {
        private Float ratio;
        private Integer width;
        private Integer height;
        private String markValue;
        private Integer fontSize = 20;
        private String imageHandlerClass;

        private ImageHandlerDescribe() {
        }

        Float getRatio() {
            return this.ratio;
        }

        void setRatio(Float ratio) {
            this.ratio = ratio;
        }

        Integer getWidth() {
            return this.width;
        }

        void setWidth(Integer width) {
            this.width = width;
        }

        Integer getHeight() {
            return this.height;
        }

        void setHeight(Integer height) {
            this.height = height;
        }

        String getImageHandlerClass() {
            return this.imageHandlerClass;
        }

        String getMarkValue() {
            return this.markValue;
        }

        void setMarkValue(String markValue) {
            this.markValue = markValue;
        }

        void setImageHandlerClass(String imageHandlerClass) {
            this.imageHandlerClass = imageHandlerClass;
        }

        Integer getFontSize() {
            return this.fontSize;
        }

        void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }
    }

    public static class Builder {
        private List<ImageHandlerDescribe> handlerDescribes = new LinkedList<ImageHandlerDescribe>();

        public Builder createCutHandler(float ratio) {
            ImageHandlerDescribe describe = new ImageHandlerDescribe();
            describe.setRatio(Float.valueOf(ratio));
            describe.setImageHandlerClass(ImageHandlerBuilder.MESS_IMAGEHANDLER_CUT_CLASS_NAME);
            this.handlerDescribes.add(describe);
            return this;
        }

        public Builder createCutHandler(int width, int height) {
            ImageHandlerDescribe describe = new ImageHandlerDescribe();
            describe.setWidth(width);
            describe.setHeight(height);
            describe.setImageHandlerClass(ImageHandlerBuilder.MESS_IMAGEHANDLER_CUT_CLASS_NAME);
            this.handlerDescribes.add(describe);
            return this;
        }

        public Builder createMarkHandler(String markValue, Integer fontSize) {
            ImageHandlerDescribe describe = new ImageHandlerDescribe();
            describe.setMarkValue(markValue);
            describe.setFontSize(fontSize);
            describe.setImageHandlerClass("yinwenjie.sample.image.service.MarkStringImageHandler");
            this.handlerDescribes.add(describe);
            return this;
        }

        public Builder createZoomHandler(float ratio) {
            ImageHandlerDescribe describe = new ImageHandlerDescribe();
            describe.setRatio(Float.valueOf(ratio));
            describe.setImageHandlerClass(ImageHandlerBuilder.MESS_IMAGEHANDLER_ZOOM_CLASS_NAME);
            this.handlerDescribes.add(describe);
            return this;
        }

        public Builder createZoomHandler(int width, int height) {
            ImageHandlerDescribe describe = new ImageHandlerDescribe();
            describe.setWidth(width);
            describe.setHeight(height);
            describe.setImageHandlerClass(ImageHandlerBuilder.MESS_IMAGEHANDLER_ZOOM_CLASS_NAME);
            this.handlerDescribes.add(describe);
            return this;
        }

        public ImageHandler build() {
            return this.nextImageHandler(0);
        }

        private ImageHandler nextImageHandler(int index) {
            if (index + 1 > this.handlerDescribes.size()) {
                return null;
            }
            ImageHandlerDescribe describe = this.handlerDescribes.get(index);
            if (StringUtils.equals((CharSequence)describe.getImageHandlerClass(), (CharSequence)ImageHandlerBuilder.MESS_IMAGEHANDLER_CUT_CLASS_NAME)) {
                if (describe.getRatio() == null) {
                    return new CutImageHandler(this.nextImageHandler(++index), describe.getWidth(), describe.getHeight());
                }
                return new CutImageHandler(this.nextImageHandler(++index), describe.getRatio().floatValue());
            }
            if (StringUtils.equals((CharSequence)describe.getImageHandlerClass(), (CharSequence)"yinwenjie.sample.image.service.MarkStringImageHandler")) {
                return new MarkStringImageHandler(this.nextImageHandler(++index), describe.getMarkValue(), describe.getFontSize());
            }
            if (StringUtils.equals((CharSequence)describe.getImageHandlerClass(), (CharSequence)ImageHandlerBuilder.MESS_IMAGEHANDLER_ZOOM_CLASS_NAME)) {
                if (describe.getRatio() == null) {
                    return new ZoomImageHandler(this.nextImageHandler(++index), describe.getWidth(), describe.getHeight());
                }
                return new ZoomImageHandler(this.nextImageHandler(++index), describe.getRatio().floatValue());
            }
            return null;
        }
    }
}

