/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.bizunited.platform.core.entity.DictCategoryEntity;
import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.repository.DictCategoryRepository;
import com.bizunited.platform.core.repository.DictItemRepository;
import com.bizunited.platform.core.repository.DictRepository;
import com.bizunited.platform.core.service.init.InitProcessService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="organizationInitProcess")
public class OrganizationInitProcess
implements InitProcessService {
    private static final String BASE_CONFIG_CODE = "baseConfig";
    private static final String BASE_CONFIG_NAME = "\u57fa\u7840\u914d\u7f6e";
    private static final String DICT_CODE = "orgType";
    private static final String DICT_TYPE = "\u901a\u7528\u578b";
    private static final String DICT_TITLE = "\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b";
    @Autowired
    private DictCategoryRepository dictCategoryRepository;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictItemRepository dictItemRepository;

    @Override
    public int sort() {
        return 5;
    }

    @Override
    public boolean doProcess() {
        return this.dictCategoryRepository.findByCateCode(BASE_CONFIG_CODE) == null || this.dictRepository.findByDictCode(DICT_CODE) == null;
    }

    @Override
    public boolean stopOnException() {
        return true;
    }

    @Override
    public void init() {
        DictCategoryEntity categoryEntity = this.dictCategoryRepository.findByCateCode(BASE_CONFIG_CODE);
        DictEntity dictEntity = this.dictRepository.findByDictCode(DICT_CODE);
        if (categoryEntity == null && dictEntity == null) {
            categoryEntity = this.initOrganizationDictCategory();
            dictEntity = this.initOrganizationDict(categoryEntity);
            this.initOrganizationDictItem(dictEntity);
        } else if (categoryEntity != null && dictEntity == null) {
            dictEntity = this.initOrganizationDict(categoryEntity);
            this.initOrganizationDictItem(dictEntity);
        }
    }

    private void initOrganizationDictItem(DictEntity dictEntity) {
        DictItemEntity itemEntity = new DictItemEntity();
        Date nowDate = new Date();
        itemEntity.setDictKey("\u90e8\u95e8");
        itemEntity.setDictValue("0");
        itemEntity.setDictItemStatus(Boolean.TRUE);
        itemEntity.setDictEntity(dictEntity);
        itemEntity.setCreateTime(nowDate);
        this.dictItemRepository.save(itemEntity);
        DictItemEntity dictItemEntity = new DictItemEntity();
        dictItemEntity.setDictKey("\u5355\u4f4d");
        dictItemEntity.setDictValue("1");
        dictItemEntity.setDictItemStatus(Boolean.TRUE);
        dictItemEntity.setDictEntity(dictEntity);
        dictItemEntity.setCreateTime(nowDate);
        this.dictItemRepository.save(dictItemEntity);
    }

    private DictEntity initOrganizationDict(DictCategoryEntity categoryEntity) {
        DictEntity dictEntity = new DictEntity();
        dictEntity.setItemNum(2);
        dictEntity.setDictStatus(Boolean.TRUE);
        dictEntity.setDictCode(DICT_CODE);
        dictEntity.setDictTitle(DICT_TITLE);
        dictEntity.setDictType(DICT_TYPE);
        dictEntity.setCategory(categoryEntity);
        dictEntity.setCreateTime(new Date());
        dictEntity.setModifyTime(new Date());
        return (DictEntity)this.dictRepository.saveAndFlush(dictEntity);
    }

    private DictCategoryEntity initOrganizationDictCategory() {
        DictCategoryEntity categoryEntity = new DictCategoryEntity();
        categoryEntity.setCreateTime(new Date());
        categoryEntity.setModifyTime(new Date());
        categoryEntity.setCateName(BASE_CONFIG_NAME);
        categoryEntity.setCateCode(BASE_CONFIG_CODE);
        return (DictCategoryEntity)this.dictCategoryRepository.saveAndFlush(categoryEntity);
    }
}

