/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.common.utils.ChineseCharUtil;
import com.bizunited.platform.core.entity.DictCategoryEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.DictCategoryRepository;
import com.bizunited.platform.core.service.DictCategoryService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="DictCategoryServiceImpl")
public class DictCategoryServiceImpl
implements DictCategoryService {
    @Autowired
    private DictCategoryRepository dictCategoryRepository;
    @Autowired
    private UserService userService;

    @Override
    @Transactional
    public DictCategoryEntity create(DictCategoryEntity entity, String parentId) {
        Validate.notNull((Object)entity, (String)"\u5b57\u5178\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u65b0\u589e\u65f6\u4e0d\u80fd\u586b\u5165Id!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getCateName(), (String)"\u5b57\u5178\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getCateCode(), (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtil.hasChinese(entity.getCateCode()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        DictCategoryEntity existCode = this.dictCategoryRepository.findByCateCode(entity.getCateCode());
        Validate.isTrue((null == existCode ? 1 : 0) != 0, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        UserEntity userEntity = this.getAccount();
        entity.setCreateUser(userEntity);
        entity.setCreateTime(new Date());
        entity.setModifyUser(userEntity);
        entity.setModifyTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            Optional op = this.dictCategoryRepository.findById(parentId);
            DictCategoryEntity parent = op.orElse(null);
            Validate.notNull((Object)parent, (String)"\u672a\u67e5\u8be2\u5230\u4f20\u5165\u7236\u7c7b\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
            entity.setParentCategory(parent);
        }
        return (DictCategoryEntity)this.dictCategoryRepository.save(entity);
    }

    @Override
    @Transactional
    public DictCategoryEntity update(DictCategoryEntity entity) {
        Validate.notNull((Object)entity, (String)"\u5b57\u5178\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u65b0\u589e\u65f6\u4e0d\u80fd\u586b\u5165Id!", (Object[])new Object[0]);
        Optional op = this.dictCategoryRepository.findById(entity.getId());
        DictCategoryEntity existId = op.orElse(null);
        Validate.notNull((Object)existId, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getCateName(), (String)"\u5b57\u5178\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity userEntity = this.getAccount();
        existId.setCateName(entity.getCateName());
        existId.setCateDesc(entity.getCateDesc());
        existId.setModifyUser(userEntity);
        existId.setModifyTime(new Date());
        return (DictCategoryEntity)this.dictCategoryRepository.save(existId);
    }

    @Override
    public void bind(String childId, String parentId) {
        Validate.notBlank((CharSequence)childId, (String)"\u5b50\u7ea7\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.dictCategoryRepository.findById(childId);
        DictCategoryEntity child = op.orElse(null);
        Validate.notNull((Object)child, (String)"\u672a\u67e5\u8be2\u5230\u5b50\u7ea7\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
        child.setParentCategory(null);
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            Validate.notBlank((CharSequence)parentId, (String)"\u7236\u7ea7\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional optional = this.dictCategoryRepository.findById(parentId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
            DictCategoryEntity parent = (DictCategoryEntity)optional.get();
            child.setParentCategory(parent);
        }
        this.dictCategoryRepository.saveAndFlush(child);
    }

    private UserEntity getAccount() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Validate.notNull((Object)securityContext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u6743\u9650\u4fe1\u606f!!", (Object[])new Object[0]);
        Authentication authentication = securityContext.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
        UserVo userVo = this.userService.findByAccount(authentication.getName());
        Validate.notNull((Object)userVo, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u8d26\u53f7\uff01", (Object[])new Object[0]);
        UserEntity userEntity = new UserEntity();
        userEntity.setId(userVo.getId());
        return userEntity;
    }

    @Override
    public DictCategoryEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dictCategoryRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public DictCategoryEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dictCategoryRepository.findDetailsById(id);
    }

    @Override
    public DictCategoryEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dictCategoryRepository.findByCateCode(code);
    }

    @Override
    public Set<DictCategoryEntity> findAll() {
        return this.dictCategoryRepository.findByTree();
    }
}

