/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.script.ScriptRepository;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import com.bizunited.platform.core.service.script.persistent.PeristentGroovyClassService;
import com.bizunited.platform.core.service.script.persistent.SimplePersistentGroovyServiceFactory;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.service.redis.RedisMutexService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ScriptServiceImpl")
public class ScriptServiceImpl
implements ScriptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptServiceImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private ScriptRepository scriptRepository;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private UserService userService;
    @Autowired
    private SimplePersistentGroovyServiceFactory simplePersistentGroovyServiceFactory;

    @Override
    public Page<ScriptEntity> findByConditions(Pageable pageable, String name, String language) {
        Validate.notNull((Object)pageable, (String)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            conditions.put("language", language);
        }
        return this.scriptRepository.queryPage(pageable, conditions);
    }

    @Override
    public ScriptEntity findById(String scriptId) {
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return null;
        }
        Optional scriptEntity = this.scriptRepository.findById(scriptId);
        return scriptEntity.isPresent() ? (ScriptEntity)scriptEntity.get() : null;
    }

    @Override
    public ScriptEntity findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.scriptRepository.findByName(name);
    }

    @Override
    public String findContentByName(String scriptName) {
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            return null;
        }
        ScriptEntity currentScript = this.findByName(scriptName);
        if (currentScript == null) {
            return null;
        }
        return this.findContentById(currentScript.getId());
    }

    @Override
    public String findContentById(String scriptId) {
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return null;
        }
        Optional scriptEntity = this.scriptRepository.findById(scriptId);
        if (!scriptEntity.isPresent()) {
            return null;
        }
        byte[] content = this.nebulaFileService.readFileContent(((ScriptEntity)scriptEntity.get()).getFileCode(), ((ScriptEntity)scriptEntity.get()).getFileName());
        return new String(content, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public ScriptEntity update(ScriptEntity scriptEntity, String scriptContent) {
        Validate.notNull((Object)scriptEntity, (String)"\u811a\u672c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptContent, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scriptEntity.getLanguage(), (String)"\u811a\u672c\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getName(), (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getId(), (String)"\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.scriptRepository.findById(scriptEntity.getId());
        ScriptEntity existEntity = op.orElse(null);
        Validate.notNull((Object)existEntity, (String)"\u67e5\u8be2\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Validate.notNull((Object)securityContext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u6743\u9650\u4fe1\u606f!!", (Object[])new Object[0]);
        Authentication authentication = securityContext.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
        UserVo modifyUserVo = this.userService.findByAccount(authentication.getName());
        Validate.notNull((Object)modifyUserVo, (String)"\u672a\u627e\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        UserEntity modifyUser = new UserEntity();
        modifyUser.setId(modifyUserVo.getId());
        String[] fileinfo = this.saveScriptContent(scriptContent);
        existEntity.setFileName(fileinfo[0]);
        existEntity.setFileCode(fileinfo[1]);
        existEntity.setModifyTime(new Date());
        existEntity.setCreateUser(modifyUser);
        existEntity.setLanguage(scriptEntity.getLanguage());
        existEntity.setName(scriptEntity.getName());
        existEntity.setDescription(scriptEntity.getDescription());
        try {
            ScriptEntity scriptEntity2 = (ScriptEntity)this.scriptRepository.save(existEntity);
            return scriptEntity2;
        }
        finally {
            PeristentGroovyClassService peristentGroovyClassService = this.simplePersistentGroovyServiceFactory.createPeristentGroovyClassService();
            peristentGroovyClassService.delete(existEntity.getId());
        }
    }

    private String[] saveScriptContent(String scriptContent) {
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + ".txt";
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/groovyScript/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] scriptContentByte = scriptContent.getBytes(StandardCharsets.UTF_8);
        this.nebulaFileService.saveFile(relativePath, fileRename, fileRename, scriptContentByte);
        return new String[]{fileRename, relativePath};
    }

    @Override
    @Transactional
    public ScriptEntity create(ScriptEntity scriptEntity, String scriptContent) {
        Validate.notNull((Object)scriptEntity, (String)"\u811a\u672c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptContent, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scriptEntity.getLanguage(), (String)"\u811a\u672c\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getName(), (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ScriptEntity existEntity = this.scriptRepository.findByName(scriptEntity.getName());
        Validate.isTrue((null == existEntity ? 1 : 0) != 0, (String)"\u811a\u672c\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Validate.notNull((Object)securityContext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u6743\u9650\u4fe1\u606f!!", (Object[])new Object[0]);
        Authentication authentication = securityContext.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
        UserVo creatorVo = this.userService.findByAccount(authentication.getName());
        Validate.notNull((Object)creatorVo, (String)"\u672a\u627e\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        UserEntity creator = new UserEntity();
        creator.setId(creatorVo.getId());
        String[] fileinfo = this.saveScriptContent(scriptContent);
        scriptEntity.setFileName(fileinfo[0]);
        scriptEntity.setFileCode(fileinfo[1]);
        scriptEntity.setCreateUser(creator);
        scriptEntity.setCreateTime(new Date());
        scriptEntity.setModifyTime(new Date());
        return (ScriptEntity)this.scriptRepository.save(scriptEntity);
    }

    @Override
    public Map<String, Object> invoke(String scriptId, Map<String, Object> params) throws InvokeProxyException {
        Validate.notBlank((CharSequence)scriptId, (String)"\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.scriptRepository.findById(scriptId);
        ScriptEntity scriptEntity = op.orElse(null);
        Validate.notNull((Object)scriptEntity, (String)"\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PeristentGroovyClassService peristentGroovyClassService = this.simplePersistentGroovyServiceFactory.createPeristentGroovyClassService();
        Script groovyScript = (Script)peristentGroovyClassService.findByClassName(scriptId);
        if (groovyScript == null) {
            byte[] scriptContent = this.nebulaFileService.readFileContent(scriptEntity.getFileCode(), scriptEntity.getFileName());
            String groovyStr = new String(scriptContent);
            GroovyShell groovyShell = new GroovyShell(this.applicationContext.getClassLoader());
            try {
                groovyScript = groovyShell.parse(groovyStr);
                peristentGroovyClassService.save(scriptEntity.getId(), groovyScript);
            }
            catch (CompilationFailedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("\u7f16\u8bd1groovy\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        Binding binding = new Binding();
        binding.setVariable("userService", (Object)this.userService);
        binding.setVariable("roleService", (Object)this.roleService);
        binding.setVariable("positionService", (Object)this.positionService);
        binding.setVariable("organizationService", (Object)this.organizationService);
        if (this.redisMutexService != null) {
            binding.setVariable("redisMutexService", (Object)this.redisMutexService);
        }
        binding.setVariable("ctx", (Object)this.applicationContext);
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry entry : params.entrySet()) {
                binding.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
        groovyScript.setBinding(binding);
        groovyScript.run();
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map map = binding.getVariables();
        if (!CollectionUtils.isEmpty((Map)map)) {
            for (String key : map.keySet()) {
                result.put(key, binding.getVariable(key));
            }
        }
        return result;
    }

    @Override
    public Object invoke(ScriptInputParamsModel model) throws InvokeProxyException {
        Validate.notNull((Object)model, (String)"\u811a\u672c\u53c2\u6570model\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(model.getScriptIds(), (String)"\u811a\u672cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        InvokeProxy groovyScriptServicableProxy = (InvokeProxy)this.applicationContext.getBean("GroovyProxy", InvokeProxy.class);
        Validate.notNull((Object)groovyScriptServicableProxy, (String)"\u6267\u884cgroovy\u811a\u672c\u65f6\u672a\u83b7\u53d6\u5230\u8c03\u7528\u4ee3\u7406\u5668\uff01", (Object[])new Object[0]);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("scriptInputParamsModel", model);
        return groovyScriptServicableProxy.doHandle(context);
    }
}

