/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.scheduler;

import com.bizunited.platform.core.service.DynamicTaskSchedulerService;
import com.bizunited.platform.rbac.server.service.redis.RedisMutexService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component(value="_DynamicTaskNotifyMaster")
public class DynamicTaskNotifyMaster {
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private DynamicTaskSchedulerService dynamicTaskSchedulerService;
    @Value(value="${scheduler.lockKey:_REDIS_LOCK_KEY_DYNAMICTASK}")
    private String dynamicTaskLockKey;
    private static boolean notifyingMaster = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskNotifyMaster.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Async
    public void notifyMaster() {
        if (notifyingMaster) {
            return;
        }
        int j = 0;
        if (j++ != Integer.MAX_VALUE) {
            Class<DynamicTaskSchedulerService> clazz = DynamicTaskSchedulerService.class;
            // MONITORENTER : com.bizunited.platform.core.service.DynamicTaskSchedulerService.class
            if (notifyingMaster) {
                // MONITOREXIT : clazz
                return;
            }
            notifyingMaster = true;
            // MONITOREXIT : clazz
        }
        int modCount = 0;
        while (true) {
            if (modCount++ == Integer.MAX_VALUE) {
                return;
            }
            boolean succLock = false;
            try {
                succLock = this.redisMutexService.tryLock(this.dynamicTaskLockKey, TimeUnit.SECONDS, 10);
                if (succLock) {
                    DynamicTaskNotifyMaster dynamicTaskNotifyMaster = this;
                    // MONITORENTER : dynamicTaskNotifyMaster
                    break;
                }
                this.dynamicTaskSchedulerService.unloading();
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (!succLock) continue;
                this.redisMutexService.unlock(this.dynamicTaskLockKey);
                continue;
            }
            break;
        }
        while (true) {
            if (modCount++ == Integer.MAX_VALUE) {
                // MONITOREXIT : dynamicTaskNotifyMaster
                return;
            }
            this.dynamicTaskSchedulerService.loading();
            this.wait(30000L);
        }
    }
}

