/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.common.enums.CompetenceTypeEnum;
import com.bizunited.platform.core.entity.ButtonEntity;
import com.bizunited.platform.core.repository.ButtonRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.ButtonService;
import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.ButtonVo;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class ButtonServiceImpl
implements ButtonService {
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    @Lazy
    private CompetenceService competenceService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;

    @Transactional
    public void bindCompetences(String buttonId, String[] competenceIds) {
        Validate.notBlank((CharSequence)buttonId, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.buttonRepository.findById(buttonId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])competenceIds, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            CompetenceVo opCompetence = this.competenceService.findById(competenceId);
            Validate.notNull((Object)opCompetence, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u63a5\u53e3\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            Validate.isTrue((boolean)CompetenceTypeEnum.COMPETENCE_VIEW_ITEM_ZERO.getType().equals(opCompetence.getViewItem()), (String)"\u53ea\u80fd\u7ed1\u5b9a\u529f\u80fd\u63a5\u53e3", (Object[])new Object[0]);
            long count = this.buttonRepository.countByCompetenceIdAndButtonId(buttonId, competenceId);
            if (count != 0L) continue;
            this.buttonRepository.bindCompetence(buttonId, competenceId);
        }
    }

    @Transactional
    public void unbindCompetences(String buttonId, String[] competenceIds) {
        Validate.notBlank((CharSequence)buttonId, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.buttonRepository.findById(buttonId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])competenceIds, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            CompetenceVo opCompetence = this.competenceService.findById(competenceId);
            Validate.notNull((Object)opCompetence, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u63a5\u53e3\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            Validate.isTrue((boolean)CompetenceTypeEnum.COMPETENCE_VIEW_ITEM_ZERO.getType().equals(opCompetence.getViewItem()), (String)"\u53ea\u80fd\u89e3\u7ed1\u529f\u80fd\u63a5\u53e3", (Object[])new Object[0]);
            this.buttonRepository.unbindCompetence(buttonId, competenceId);
        }
    }

    public ButtonVo findDateilsById(String buttonId) {
        if (StringUtils.isBlank((CharSequence)buttonId)) {
            return null;
        }
        ButtonEntity button = this.buttonRepository.findDateilsById(buttonId);
        if (button != null) {
            return this.nebulaToolkitService.copyObjectByWhiteList(button, ButtonVo.class, HashSet.class, ArrayList.class, "competences", "competence", "roles");
        }
        return null;
    }

    public Set<ButtonVo> findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Sets.newHashSet();
        }
        HashSet<ButtonVo> buttonVos = new HashSet<ButtonVo>();
        List roleVos = this.roleService.findAllByUserId(userId, Integer.valueOf(0));
        for (RoleVo role : roleVos) {
            Set<ButtonEntity> buttons = this.buttonRepository.findByRoleId(role.getId());
            if (CollectionUtils.isEmpty(buttons)) continue;
            Collection<ButtonVo> buttonVo = this.nebulaToolkitService.copyCollectionByWhiteList(buttons, ButtonEntity.class, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            buttonVos.addAll(buttonVo);
        }
        return this.distinctByCode(buttonVos);
    }

    @Transactional
    public ButtonVo create(ButtonVo button) {
        this.createValidation(button);
        ButtonEntity currentButton = this.nebulaToolkitService.copyObjectByWhiteList(button, ButtonEntity.class, HashSet.class, ArrayList.class, "competence");
        Date nowDate = new Date();
        currentButton.setCreateTime(nowDate);
        currentButton.setModifyTime(nowDate);
        currentButton.setSystem(false);
        this.buttonRepository.save(currentButton);
        button.setId(currentButton.getId());
        return button;
    }

    @Transactional
    public void batchCreate(Set<ButtonVo> buttons) {
        Validate.notEmpty(buttons, (String)"\u6279\u91cf\u521b\u5efa\u6309\u94ae\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u6309\u94ae!!", (Object[])new Object[0]);
        HashSet<ButtonEntity> buttonSet = new HashSet<ButtonEntity>();
        HashSet<String> codes = new HashSet<String>();
        for (ButtonVo buttonVo : buttons) {
            this.createValidation(buttonVo);
            Validate.isTrue((!codes.contains(buttonVo.getCode()) ? 1 : 0) != 0, (String)"\u4f20\u5165\u6309\u94ae\u6570\u636e\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            codes.add(buttonVo.getCode());
            ButtonEntity currentButton = this.nebulaToolkitService.copyObjectByWhiteList(buttonVo, ButtonEntity.class, HashSet.class, ArrayList.class, "competence");
            currentButton.setCreateTime(new Date());
            currentButton.setModifyTime(new Date());
            currentButton.setSystem(false);
            buttonSet.add(currentButton);
        }
        this.buttonRepository.saveAll(buttonSet);
    }

    @Transactional
    public ButtonVo update(ButtonVo button) {
        this.updateValidation(button);
        ButtonEntity updateButton = this.buttonRepository.findById(button.getId()).orElse(null);
        Validate.notNull((Object)updateButton, (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u6309\u94ae\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((updateButton.getSystem() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u6309\u94ae\u4e0d\u80fd\u66f4\u65b0", (Object[])new Object[0]);
        if (button.getButtonDesc() != null) {
            updateButton.setButtonDesc(button.getButtonDesc());
        }
        updateButton.setName(button.getName());
        updateButton.setCode(button.getCode());
        updateButton.setModifyTime(new Date());
        this.buttonRepository.save(updateButton);
        return this.nebulaToolkitService.copyObjectByWhiteList(updateButton, ButtonVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void deleteById(String id) {
        Validate.notNull((Object)id, (String)"\u5220\u9664\u5fc5\u987b\u8981\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!", (Object[])new Object[0]);
        ButtonEntity button = this.buttonRepository.findById(id).orElse(null);
        if (button == null) {
            return;
        }
        Validate.isTrue((button.getSystem() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u6309\u94ae\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        this.buttonRepository.unbindRoleById(id);
        this.buttonRepository.unbindCompetenceById(id);
        this.buttonRepository.delete(button);
    }

    @Transactional
    public void batchDelete(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u6279\u91cf\u5220\u9664\u6309\u94ae\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94aeid!!", (Object[])new Object[0]);
        for (String id : ids) {
            this.deleteById(id);
        }
    }

    public Set<ButtonVo> findByCompetenceId(String competenceId) {
        if (StringUtils.isBlank((CharSequence)competenceId)) {
            return Sets.newHashSet();
        }
        Set<ButtonEntity> buttons = this.buttonRepository.findByCompetenceId(competenceId);
        if (CollectionUtils.isEmpty(buttons)) {
            return Sets.newHashSet();
        }
        Collection<ButtonVo> buttonVos = this.nebulaToolkitService.copyCollectionByWhiteList(buttons, ButtonEntity.class, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet(buttonVos);
    }

    public Set<ButtonVo> findByRoleCode(String roleCode) {
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            return Sets.newHashSet();
        }
        Set<ButtonEntity> buttons = this.buttonRepository.findByRoleCode(roleCode);
        if (CollectionUtils.isEmpty(buttons)) {
            return Sets.newHashSet();
        }
        Collection<ButtonVo> buttonVos = this.nebulaToolkitService.copyCollectionByWhiteList(buttons, ButtonEntity.class, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(buttonVos);
    }

    public Set<ButtonVo> findByCurrentUser(Principal principal) {
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u83b7\u53d6\u5230\u767b\u5f55\u8d26\u53f7\u4fe1\u606f\uff01", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff1a%s", (Object[])new Object[]{account});
        List roles = this.roleService.findAllByUserId(user.getId(), Integer.valueOf(0));
        Validate.notEmpty((Collection)roles, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u672a\u914d\u7f6e\u89d2\u8272\uff01", (Object[])new Object[0]);
        List roleNames = roles.stream().map(RoleVo::getRoleName).collect(Collectors.toList());
        Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.ignoreMethodCheckRoles), (Set)Sets.newHashSet(roleNames));
        HashSet<ButtonVo> buttonVos = new HashSet<ButtonVo>();
        if (!CollectionUtils.isEmpty((Collection)intersections)) {
            List buttons = this.buttonRepository.findAll();
            Collection<ButtonVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(buttons, ButtonEntity.class, ButtonVo.class, HashSet.class, ArrayList.class, new String[0]);
            buttonVos.addAll(vos);
            return buttonVos;
        }
        for (RoleVo role : roles) {
            Set<ButtonEntity> buttons = this.buttonRepository.findByRoleId(role.getId());
            Collection<ButtonVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(buttons, ButtonEntity.class, ButtonVo.class, HashSet.class, ArrayList.class, new String[0]);
            buttonVos.addAll(vos);
        }
        return this.distinctByCode(buttonVos);
    }

    private Set<ButtonVo> distinctByCode(Set<ButtonVo> buttons) {
        if (CollectionUtils.isEmpty(buttons)) {
            return buttons;
        }
        HashSet<String> buttonCodes = new HashSet<String>();
        Iterator<ButtonVo> iterator = buttons.iterator();
        while (iterator.hasNext()) {
            ButtonVo button = iterator.next();
            if (buttonCodes.add(button.getCode())) continue;
            iterator.remove();
        }
        return buttons;
    }

    private void updateValidation(ButtonVo button) {
        Validate.notBlank((CharSequence)button.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getName(), (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getId(), (String)"\u4fee\u6539\u6570\u636e\u5fc5\u987b\u8981\u6709ID", (Object[])new Object[0]);
        long countByCode = this.buttonRepository.countByCodeWithoutId(button.getCode(), button.getId());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u6309\u94ae\u7684\u7f16\u7801[%s]\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{button.getCode()});
    }

    private void createValidation(ButtonVo button) {
        Validate.notNull((Object)button, (String)"\u4fdd\u5b58\u7684\u6309\u94ae\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)button.getCompetence(), (String)"\u83dc\u5355\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getCompetence().getId(), (String)"\u83dc\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getName(), (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((button.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6570\u636e\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        CompetenceVo competenceVo = this.competenceService.findById(button.getCompetence().getId());
        Validate.notNull((Object)competenceVo, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u83dc\u5355!", (Object[])new Object[0]);
        Validate.isTrue((competenceVo.getViewItem() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u529f\u80fd\u5fc5\u987b\u662f\u83dc\u5355!", (Object[])new Object[0]);
        long countByCode = this.buttonRepository.countByCode(button.getCode());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u6309\u94ae\u7684\u7f16\u7801[%s]\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{button.getCode()});
    }
}

