/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.enums.RbacRelationEnum;
import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.PositionEntity;
import com.bizunited.platform.core.entity.RbacSettingEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.OrganizationRepository;
import com.bizunited.platform.core.repository.PositionRepository;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.security.RbacSettingService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class PositionServiceImpl
implements PositionService {
    @Autowired
    private PositionRepository positionRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RbacSettingService rbacSettingService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedissonClient redissonClient;

    @Transactional
    public PositionVo create(PositionVo positionVo) {
        Validate.notNull((Object)positionVo, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)positionVo.getId()), (String)"\u6dfb\u52a0\u5c97\u4f4d\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionVo.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)positionVo.getCode(), (String)"\u5c97\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        positionVo.setCreateTime(new Date());
        PositionEntity currentPosition = this.positionRepository.findByCode(positionVo.getCode());
        Validate.isTrue((null == currentPosition ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684code,\u8bf7\u91cd\u65b0\u8f93\u5165\u5c97\u4f4d\u7f16\u7801!!", (Object[])new Object[0]);
        if (positionVo.getParent() != null) {
            Validate.notBlank((CharSequence)positionVo.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            PositionEntity parent = this.positionRepository.findById(positionVo.getParent().getId()).orElse(null);
            Validate.notNull((Object)parent, (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
        PositionEntity positionEntity = this.nebulaToolkitService.copyObjectByWhiteList(positionVo, PositionEntity.class, HashSet.class, ArrayList.class, "parent");
        this.positionRepository.save(positionEntity);
        positionVo.setId(positionEntity.getId());
        return positionVo;
    }

    @Transactional
    public PositionVo update(PositionVo positionVo) {
        Validate.notNull((Object)positionVo, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)positionVo.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u5c97\u4f4d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u4fee\u6539!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionVo.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionVo.getId());
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        if (positionVo.getParent() != null) {
            String parentId = positionVo.getParent().getId();
            Validate.notBlank((CharSequence)parentId, (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((!positionVo.getId().equals(parentId) ? 1 : 0) != 0, (String)"\u7981\u6b62\u5c06\u8be5\u5c97\u4f4d\u672c\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u5c97\u4f4d", (Object[])new Object[0]);
            PositionEntity parent = this.positionRepository.findById(parentId).orElse(null);
            Validate.notNull((Object)parent, (String)"\u672a\u627e\u5230\u8be5\u5c97\u4f4d\u7684\u4e0a\u7ea7\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            position.setParent(parent);
        } else {
            position.setParent(null);
        }
        position.setName(positionVo.getName());
        HashSet<String> positionStack = new HashSet<String>();
        positionStack.add(position.getId());
        this.validateCircular(position, positionStack);
        this.positionRepository.save(position);
        return this.nebulaToolkitService.copyObjectByWhiteList(position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateCircular(PositionEntity parent, Set<String> positionStack) {
        if (CollectionUtils.isEmpty(parent.getChildren())) {
            return;
        }
        for (PositionEntity positionEntity : parent.getChildren()) {
            Validate.isTrue((!positionStack.contains(positionEntity.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            positionStack.add(positionEntity.getId());
            this.validateCircular(positionEntity, positionStack);
        }
    }

    @Transactional
    public PositionVo updateStatus(String positionId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u6ca1\u6709\u8be5\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer status = position.getTstatus();
        status = status == 1 ? 0 : 1;
        position.setTstatus(status);
        this.positionRepository.save(position);
        return this.nebulaToolkitService.copyObjectByWhiteList(position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public PositionVo findDetailsById(String positionId) {
        if (StringUtils.isBlank((CharSequence)positionId)) {
            return null;
        }
        PositionEntity positionEntity = this.positionRepository.findDetailsById(positionId);
        Validate.notNull((Object)positionEntity, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2!!", (Object[])new Object[0]);
        return this.nebulaToolkitService.copyObjectByWhiteList(positionEntity, PositionVo.class, LinkedHashSet.class, ArrayList.class, "organization", "roles", "users");
    }

    @Transactional
    public void bindOrgAndPosition(String orgId, String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.organizationRepository.findById(orgId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784!", (Object[])new Object[0]);
        OrganizationEntity organization = (OrganizationEntity)optional.get();
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.isTrue((null == position.getOrganization() ? 1 : 0) != 0, (String)"\u8be5\u5c97\u4f4d\u5df2\u7ed1\u5b9a\u6709\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        position.setOrganization(organization);
        this.positionRepository.saveAndFlush(position);
    }

    @Transactional
    public void unbindOrgAndPosition(String orgId, String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.organizationRepository.findById(orgId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784!", (Object[])new Object[0]);
        OrganizationEntity organization = (OrganizationEntity)optional.get();
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.notNull((Object)position.getOrganization(), (String)"\u8be5\u5c97\u4f4d\u6ca1\u6709\u7ed1\u5b9a\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)organization.getId().equals(position.getOrganization().getId()), (String)"\u5f85\u89e3\u7ed1\u7684\u5c97\u4f4d\u4e0e\u7ec4\u7ec7\u673a\u6784\u6ca1\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        position.setOrganization(null);
        this.positionRepository.saveAndFlush(position);
    }

    private void validateBindRole(String positionId, String roleId) {
        RbacSettingEntity rbacSettingEntity = this.rbacSettingService.findRbacSetting();
        if (rbacSettingEntity == null) {
            long count = this.positionRepository.countByRoleAndPosition(roleId, positionId);
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
        } else {
            long count;
            int bindRelation = rbacSettingEntity.getRolePositionRelation();
            if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
                count = this.positionRepository.countByRoleAndPosition(roleId, positionId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
            }
            if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
                count = this.positionRepository.countPositionByRoleId(roleId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
                count = this.positionRepository.countRoleByPositionId(positionId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
                long countRole = this.positionRepository.countRoleByPositionId(positionId);
                Validate.isTrue((countRole == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionId});
                long countPosition = this.positionRepository.countPositionByRoleId(roleId);
                Validate.isTrue((countPosition == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
            }
        }
    }

    @Transactional
    public void bindRoleAndPosition(String roleId, String positionId) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        this.validateBindRole(positionId, roleId);
        this.positionRepository.bindRole(roleId, positionId);
    }

    @Transactional
    public void bindRolesAndPosition(List<String> roleIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(roleIds) ? 1 : 0) != 0, (String)"\u89d2\u8272ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        roleIds.stream().forEach(o -> this.bindRoleAndPosition((String)o, positionId));
    }

    @Transactional
    public void unbindRoleAndPosition(String roleId, String positionId) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        this.positionRepository.unbindRole(roleId, positionId);
    }

    @Transactional
    public void unbindRolesAndPosition(List<String> roleIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(roleIds) ? 1 : 0) != 0, (String)"\u89d2\u8272ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        roleIds.stream().forEach(o -> this.unbindRoleAndPosition((String)o, positionId));
    }

    @Transactional
    public void bindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(userIds) ? 1 : 0) != 0, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        RbacSettingEntity rbacSettingEntity = this.rbacSettingService.findRbacSetting();
        userIds.stream().forEach(o -> this.bindUserAndPosition(rbacSettingEntity, (String)o, positionId));
    }

    private void validateBindUser(RbacSettingEntity rbacSettingEntity, String positionId, String userId) {
        if (rbacSettingEntity == null) {
            long count = this.positionRepository.countByUserAndPosition(userId, positionId);
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        } else {
            long count;
            int bindRelation = rbacSettingEntity.getUserPositionRelation();
            if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
                count = this.positionRepository.countByUserAndPosition(userId, positionId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
                count = this.positionRepository.countPositionByUserId(userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
                count = this.positionRepository.countUserByPositionId(positionId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
                long countUser = this.positionRepository.countUserByPositionId(positionId);
                Validate.isTrue((countUser == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionId});
                long countPosition = this.positionRepository.countPositionByUserId(userId);
                Validate.isTrue((countPosition == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
        }
    }

    private void bindUserAndPosition(RbacSettingEntity rbacSettingEntity, String userId, String positionId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        UserEntity userEntity = op.orElse(null);
        Validate.notNull((Object)userEntity, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237!", (Object[])new Object[0]);
        Optional optional = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        this.validateBindUser(rbacSettingEntity, positionId, userId);
        this.positionRepository.binduser(userId, positionId);
    }

    @Transactional
    public void unbindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(userIds) ? 1 : 0) != 0, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        userIds.stream().forEach(o -> this.unbindUserAndPosition((String)o, positionId));
    }

    private void unbindUserAndPosition(String userId, String positionId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237!", (Object[])new Object[0]);
        Optional optional = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.isTrue((0L != this.positionRepository.countByUserAndPosition(userId, positionId) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u4e0e\u8be5\u5c97\u4f4d\u672a\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        PositionVo positionVo = null;
        String key = "rbac:user:" + userId;
        RMap mainPosition = this.redissonClient.getMap(key);
        if (mainPosition.containsKey("mainPosition")) {
            positionVo = (PositionVo)JSONObject.parseObject((String)((String)mainPosition.get("mainPosition")), PositionVo.class);
        }
        if (positionVo != null) {
            mainPosition.remove("mainPosition");
        }
        this.positionRepository.unbinduser(userId, positionId);
    }

    public List<PositionVo> findByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findDetailsById(userId);
        if (user == null) {
            return null;
        }
        if (!CollectionUtils.isEmpty(user.getPositions())) {
            Set<PositionEntity> positions = user.getPositions();
            Collection<PositionVo> positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positions, PositionEntity.class, PositionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return Lists.newArrayList(positionVos);
        }
        return Lists.newArrayList();
    }

    public Set<PositionVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<PositionEntity> pos = this.positionRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(pos)) {
            return Sets.newHashSet();
        }
        Collection<PositionVo> pvo = this.nebulaToolkitService.copyCollectionByWhiteList(pos, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(pvo);
    }

    public Page<PositionVo> findByConditions(String code, String name, Integer tstatus, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (tstatus != null) {
            conditions.put("tstatus", tstatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        Page positionEntityPage = this.positionRepository.queryPage(pageable, conditions);
        List positionEntitys = positionEntityPage.getContent();
        PageImpl positionVoPage = null;
        if (!positionEntitys.isEmpty()) {
            Collection<PositionVo> positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positionEntitys, PositionEntity.class, PositionVo.class, LinkedHashSet.class, ArrayList.class, "users", "parent", "children");
            positionVoPage = new PageImpl(new ArrayList<PositionVo>(positionVos), pageable, positionEntityPage.getTotalElements());
        } else {
            positionVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return positionVoPage;
    }

    public PositionVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        PositionEntity position = this.positionRepository.findByCode(code);
        if (position == null) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public UserVo changePosition(String positionId, String userId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5207\u6362\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findById(userId).orElse(null);
        Validate.notNull((Object)user, (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        UserVo userVo = this.nebulaToolkitService.copyObjectByWhiteList(user, UserVo.class, HashSet.class, ArrayList.class, "roles");
        PositionEntity positionEntity = this.positionRepository.findById(positionId).orElse(null);
        Validate.notNull((Object)positionEntity, (String)"\u672a\u83b7\u53d6\u5230\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        PositionVo positionVo = this.nebulaToolkitService.copyObjectByWhiteList(positionEntity, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<PositionVo> positionVos = this.findByUserId(userId);
        userVo.setPositions((Set)Sets.newLinkedHashSet(positionVos));
        userVo.setMainPosition(positionId);
        RMap mainPosition = this.redissonClient.getMap("rbac:user:" + userId);
        mainPosition.put("mainPosition", JSONObject.toJSON((Object)positionVo).toString());
        return userVo;
    }

    public PositionVo findMainPositionByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PositionVo positionVo = null;
        String key = "rbac:user:" + userId;
        RMap mainPosition = this.redissonClient.getMap(key);
        if (mainPosition.containsKey("mainPosition")) {
            positionVo = (PositionVo)JSONObject.parseObject((String)((String)mainPosition.get("mainPosition")), PositionVo.class);
        }
        if (positionVo == null) {
            List<PositionVo> positionVoList = this.findByUserId(userId);
            if (CollectionUtils.isEmpty(positionVoList)) {
                return null;
            }
            positionVo = positionVoList.get(0);
            String json = JSONObject.toJSON((Object)positionVo).toString();
            mainPosition.put("mainPosition", json);
        }
        return positionVo;
    }
}

