/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.common.enums.RbacRelationEnum;
import com.bizunited.platform.core.entity.RbacSettingEntity;
import com.bizunited.platform.core.repository.RbacSettingRepository;
import com.bizunited.platform.core.service.security.RbacSettingService;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RbacSettingServiceImpl")
public class RbacSettingServiceImpl
implements RbacSettingService {
    @Autowired
    private RbacSettingRepository rbacSettingRepository;

    @Override
    @Transactional
    public void init() {
        List settings = this.rbacSettingRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)settings)) {
            return;
        }
        RbacSettingEntity setting = new RbacSettingEntity();
        setting.setUserGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setUserOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setUserRoleRelation(RbacRelationEnum.MANY_TO_MANY.getRelation());
        setting.setUserPositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setRoleGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setRoleOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setRolePositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setOrgPositionRelation(RbacRelationEnum.ONE_TO_MANY.getRelation());
        this.rbacSettingRepository.save(setting);
    }

    @Override
    @Transactional
    public RbacSettingEntity update(RbacSettingEntity setting) {
        Validate.notBlank((CharSequence)setting.getId(), (String)"\u66f4\u65b0\u65f6\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a!!!", (Object[])new Object[0]);
        RbacSettingEntity rbacSetting = this.rbacSettingRepository.findById(setting.getId()).orElse(null);
        Validate.notNull((Object)rbacSetting, (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01", (Object[])new Object[0]);
        if (setting.getUserGroupRelation() != null) {
            rbacSetting.setUserGroupRelation(setting.getUserGroupRelation());
        }
        if (setting.getUserOrgRelation() != null) {
            rbacSetting.setUserOrgRelation(setting.getUserOrgRelation());
        }
        if (setting.getUserRoleRelation() != null) {
            rbacSetting.setUserRoleRelation(setting.getUserRoleRelation());
        }
        if (setting.getUserPositionRelation() != null) {
            rbacSetting.setUserPositionRelation(setting.getUserPositionRelation());
        }
        if (setting.getRoleGroupRelation() != null) {
            rbacSetting.setRoleGroupRelation(setting.getRoleGroupRelation());
        }
        if (setting.getRoleOrgRelation() != null) {
            rbacSetting.setRoleOrgRelation(setting.getRoleOrgRelation());
        }
        if (setting.getRolePositionRelation() != null) {
            rbacSetting.setRolePositionRelation(setting.getRolePositionRelation());
        }
        if (setting.getOrgPositionRelation() != null) {
            rbacSetting.setOrgPositionRelation(setting.getOrgPositionRelation());
        }
        this.rbacSettingRepository.save(rbacSetting);
        return rbacSetting;
    }

    @Override
    public RbacSettingEntity findRbacSetting() {
        List settings = this.rbacSettingRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)settings)) {
            return null;
        }
        return (RbacSettingEntity)settings.get(0);
    }
}

