/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.common.enums.RbacRelationEnum;
import com.bizunited.platform.core.entity.RbacSettingEntity;
import com.bizunited.platform.core.entity.UserGroupEntity;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserGroupRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.security.RbacSettingService;
import com.bizunited.platform.rbac.server.service.UserGroupService;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class UserGroupServiceImpl
implements UserGroupService {
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RbacSettingService rbacSettingService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static final String ERROR_GROUP_ID = "\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5";
    private static final String ERROR_NOT_FOUND = "\u6ca1\u6709\u8be5\u5de5\u4f5c\u7ec4\uff0c\u8bf7\u68c0\u67e5!!";

    @Transactional
    public UserGroupVo create(UserGroupVo userGroup) {
        Validate.notNull((Object)userGroup, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)userGroup.getId()), (String)"\u6dfb\u52a0\u5206\u7ec4\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5206\u7ec4id,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String groupName = userGroup.getGroupName();
        Validate.notBlank((CharSequence)groupName, (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!UserGroupServiceImpl.isChinese(groupName) ? 1 : 0) != 0, (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userGroup.getGroupDescription(), (String)"\u5206\u7ec4\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)userGroup.getTstatus(), (String)"\u5206\u7ec4\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserGroupEntity oldUserGroup = this.userGroupRepository.findByGroupName(groupName);
        Validate.isTrue((null == oldUserGroup ? 1 : 0) != 0, (String)"\u8be5\u5206\u7ec4\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5206\u7ec4\u540d", (Object[])new Object[0]);
        UserGroupEntity userGroupEntity = this.nebulaToolkitService.copyObjectByWhiteList(userGroup, UserGroupEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.userGroupRepository.save(userGroupEntity);
        userGroup.setId(userGroupEntity.getId());
        return userGroup;
    }

    @Transactional
    public UserGroupVo update(UserGroupVo userGroup) {
        Validate.notNull((Object)userGroup, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String groupId = userGroup.getId();
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u8be5\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5206\u7ec4\u540d", (Object[])new Object[0]);
        UserGroupEntity currentGroup = (UserGroupEntity)op.get();
        if (!StringUtils.isBlank((CharSequence)userGroup.getGroupDescription())) {
            currentGroup.setGroupDescription(userGroup.getGroupDescription());
            this.userGroupRepository.save(currentGroup);
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(currentGroup, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public UserGroupVo updateStatus(String groupId) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        UserGroupEntity userGroup = (UserGroupEntity)op.get();
        Integer status = userGroup.getTstatus();
        status = status == 1 ? 0 : 1;
        userGroup.setTstatus(status);
        this.userGroupRepository.save(userGroup);
        return this.nebulaToolkitService.copyObjectByWhiteList(userGroup, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateBindUser(RbacSettingEntity rbacSettingEntity, String groupId, String userId) {
        Optional optional = this.userRepository.findById(userId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u8be5\u7528\u6237[%s],\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        if (rbacSettingEntity == null) {
            long count = this.userGroupRepository.countUserGroup(groupId, userId);
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
        } else {
            long count;
            int bindRelation = rbacSettingEntity.getUserGroupRelation();
            if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
                count = this.userGroupRepository.countUserGroup(groupId, userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
                count = this.userGroupRepository.countGroupByUserId(userId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5206\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
                count = this.userGroupRepository.countUserByGroupId(groupId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u5206\u7ec4[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{groupId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
                long countGroup = this.userGroupRepository.countGroupByUserId(userId);
                Validate.isTrue((countGroup == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5206\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userId});
                long countUser = this.userGroupRepository.countUserByGroupId(groupId);
                Validate.isTrue((countUser == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u7528\u6237\u548c\u5206\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u5206\u7ec4[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{groupId});
            }
        }
    }

    @Transactional
    public void bindUser(String groupId, String[] userIds) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        RbacSettingEntity rbacSettingEntity = this.rbacSettingService.findRbacSetting();
        for (String userId : userIds) {
            this.validateBindUser(rbacSettingEntity, groupId, userId);
            this.userGroupRepository.bindUser(groupId, userId);
        }
    }

    @Transactional
    public void unBindUser(String groupId, String[] userIds) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        for (String userId : userIds) {
            Optional optional = this.userRepository.findById(userId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u8be5\u7528\u6237,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            this.userGroupRepository.unBindUser(groupId, userId);
        }
    }

    private void validateBindRole(RbacSettingEntity rbacSettingEntity, String groupId, String roleId) {
        Optional optional = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u8be5\u89d2\u8272[%s],\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
        if (rbacSettingEntity == null) {
            long count = this.userGroupRepository.countRoleGroup(groupId, roleId);
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
        } else {
            long count;
            int bindRelation = rbacSettingEntity.getRoleGroupRelation();
            if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
                count = this.userGroupRepository.countRoleGroup(groupId, roleId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5206\u7ec4\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
            }
            if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
                count = this.userGroupRepository.countGroupByRoleId(roleId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5206\u7ec4\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5206\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
                count = this.userGroupRepository.countRoleByGroupId(groupId);
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5206\u7ec4\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u5206\u7ec4[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{groupId});
            }
            if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
                long countGroup = this.userGroupRepository.countGroupByRoleId(roleId);
                Validate.isTrue((countGroup == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5206\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5206\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
                long countRole = this.userGroupRepository.countRoleByGroupId(groupId);
                Validate.isTrue((countRole == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5206\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u5206\u7ec4[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{groupId});
            }
        }
    }

    @Transactional
    public void bindRole(String groupId, String[] roleIds) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        RbacSettingEntity rbacSettingEntity = this.rbacSettingService.findRbacSetting();
        for (String roleId : roleIds) {
            this.validateBindRole(rbacSettingEntity, groupId, roleId);
            this.userGroupRepository.bindRole(groupId, roleId);
        }
    }

    @Transactional
    public void unBindRole(String groupId, String[] roleIds) {
        Validate.notNull((Object)groupId, (String)ERROR_GROUP_ID, (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a\uff08\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.userGroupRepository.findById(groupId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_NOT_FOUND, (Object[])new Object[0]);
        for (String roleId : roleIds) {
            Optional optional = this.roleRepository.findById(roleId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u8be5\u89d2\u8272[%s],\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleId});
            this.userGroupRepository.unBindRole(groupId, roleId);
        }
    }

    public Set<UserGroupVo> findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Sets.newHashSet();
        }
        Set<UserGroupEntity> userGroupEntitys = this.userGroupRepository.findDetailsById(id);
        if (userGroupEntitys == null || userGroupEntitys.isEmpty()) {
            return Sets.newHashSet();
        }
        Collection<UserGroupVo> userGroupVos = this.nebulaToolkitService.copyCollectionByWhiteList(userGroupEntitys, UserGroupEntity.class, UserGroupVo.class, LinkedHashSet.class, ArrayList.class, "roles", "users");
        return Sets.newHashSet(userGroupVos);
    }

    public Set<UserGroupVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<UserGroupEntity> groups = this.userGroupRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(groups)) {
            return Sets.newHashSet();
        }
        Collection<UserGroupVo> ugroups = this.nebulaToolkitService.copyCollectionByWhiteList(groups, UserGroupEntity.class, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(ugroups);
    }

    private static boolean isChinese(String str) {
        String regEx = "[\\u4e00-\\u9fa5]+";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public Set<UserGroupVo> findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Sets.newHashSet();
        }
        Set<UserGroupEntity> userGroups = this.userGroupRepository.findByUserId(userId);
        if (CollectionUtils.isEmpty(userGroups)) {
            return Sets.newHashSet();
        }
        Collection<UserGroupVo> groups = this.nebulaToolkitService.copyCollectionByWhiteList(userGroups, UserGroupEntity.class, UserGroupVo.class, HashSet.class, ArrayList.class, "users", "roles");
        return Sets.newLinkedHashSet(groups);
    }

    public Page<UserGroupVo> findByCondition(String groupName, Integer status, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            conditions.put("groupName", groupName);
        }
        if (status != null) {
            conditions.put("status", status);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        Page userGroupPage = this.userGroupRepository.queryPage(pageable, conditions);
        List userGroupEntitys = userGroupPage.getContent();
        PageImpl userGroupVoPage = null;
        if (!userGroupEntitys.isEmpty()) {
            Collection<UserGroupVo> userGroupVos = this.nebulaToolkitService.copyCollectionByWhiteList(userGroupEntitys, UserGroupEntity.class, UserGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            userGroupVoPage = new PageImpl(new ArrayList<UserGroupVo>(userGroupVos), pageable, userGroupPage.getTotalElements());
        } else {
            userGroupVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return userGroupVoPage;
    }

    public UserGroupVo findByGroupName(String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return null;
        }
        UserGroupEntity userGroup = this.userGroupRepository.findByGroupName(groupName);
        if (userGroup == null) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(userGroup, UserGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserGroupVo> findAll() {
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")});
        List entitySet = this.userGroupRepository.findAll(sort);
        if (CollectionUtils.isEmpty((Collection)entitySet)) {
            return Lists.newArrayList();
        }
        Collection<UserGroupVo> groups = this.nebulaToolkitService.copyCollectionByWhiteList(entitySet, UserGroupEntity.class, UserGroupVo.class, HashSet.class, ArrayList.class, "users", "roles");
        return Lists.newArrayList(groups);
    }
}

