/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.constant.ParamClassTypeConst;
import com.bizunited.platform.core.common.utils.ParamsAnalysisUtil;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

@Component(value="SpringMVCParamsHandle")
public class ServicableInvokeHandle
implements InvokeRequestHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicableInvokeHandle.class);
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        InputParamsModel model = (InputParamsModel)context.getChainParam(InputParamsModel.class.getName());
        Validate.notNull((Object)model, (String)"\u4f7f\u7528SpringMVCParamsHandle\u5206\u6790\u5165\u53c2\u60c5\u51b5\u662f\uff0c\u521d\u59cb\u5316\u7684\u5165\u53c2\u5bf9\u8c61InputParamsModel\uff0c\u5fc5\u987b\u901a\u8fc7InputParamsModel.class.getName()\u4f5c\u4e3akey\u7684\u65b9\u5f0f\u5728\u8c03\u7528\u65f6\u4f20\u5165", (Object[])new Object[0]);
        Object principalValue = context.getChainParam("principal");
        Validate.notNull((Object)principalValue, (String)"\u5728\u5904\u7406SpringMVCParamsHandle\u65f6\uff0c\u6ca1\u6709\u53d1\u73b0\u767b\u5f55\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String userName = principalValue.toString();
        String servicableMethodName = model.getServiceName();
        Validate.notBlank((CharSequence)servicableMethodName, (String)"\u9519\u8bef\u7684\u9759\u6001\u670d\u52a1\u6e90\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ServicableMethodEntity currentServicableMethod = this.servicableMethodService.findByName(servicableMethodName);
        Validate.notNull((Object)currentServicableMethod, (String)"\u4e3a\u627e\u5230\u670d\u52a1\u6e90\u53c2\u6570[ServicableMethodEntity]\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (currentServicableMethod.getProperties() == null || currentServicableMethod.getProperties().isEmpty()) {
            chain.doHandle(context, HandleChain.ChainLogic.BREAK);
        }
        HashMap<String, Object> assembleMap = new HashMap<String, Object>();
        TreeSet<ServicableMethodPropertyEntity> properties = new TreeSet<ServicableMethodPropertyEntity>((e1, e2) -> e1.getPropertyIndex() - e2.getPropertyIndex());
        properties.addAll(currentServicableMethod.getProperties());
        Object[] args = new Object[properties.size()];
        Class[] argsClass = new Class[properties.size()];
        LOGGER.debug("****{}\u670d\u52a1\u52a8\u6001\u8c03\u7528****\u5f00\u59cb\u51c6\u5907\u5904\u7406\u53c2\u6570*****\u9700\u8981\u5904\u7406\u7684\u53c2\u6570\u4e2a\u6570\uff1a{}", (Object)model.getServiceName(), (Object)(properties == null || properties.isEmpty() ? 0 : properties.size()));
        if (model.getParams() != null && !model.getParams().isEmpty()) {
            assembleMap.putAll(model.getParams());
        }
        if (model.getCustomData() != null && !model.getCustomData().isEmpty()) {
            Set<String> customSet = model.getCustomData().keySet();
            Validate.isTrue((boolean)Sets.intersection(customSet, assembleMap.keySet()).isEmpty(), (String)"\u4f20\u5165\u7684params\u548ccustomData\u6709\u952e\u503c\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            assembleMap.putAll(model.getCustomData());
        }
        InvokeParams conditionParams = new InvokeParams();
        boolean existMap = properties.stream().anyMatch(e -> e.getParamType() == 5);
        if (existMap) {
            if (model.isFilterParamsExist()) {
                List<InvokeOperations> filterParams = model.getFilterParams();
                Iterator<InvokeOperations> iterator = filterParams.iterator();
                while (iterator.hasNext()) {
                    InvokeOperations k = iterator.next();
                    conditionParams.add(k.getParamName(), k, true);
                }
            }
            for (Map.Entry entry : assembleMap.entrySet()) {
                InvokeOperations m = new InvokeOperations();
                m.setParamName((String)entry.getKey());
                m.setCompareValue(entry.getValue());
                conditionParams.add((String)entry.getKey(), m, false);
            }
        }
        Class<?> iocBeanClass = null;
        try {
            this.analysis(context, model, args, argsClass, userName, properties, assembleMap, conditionParams);
            iocBeanClass = context.getClassLoader().loadClass(currentServicableMethod.getInterfaceName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
        }
        LOGGER.debug("*******************\u53c2\u6570\u5904\u7406\u7ed3\u675f**********************");
        Validate.notNull(iocBeanClass, (String)"\u672a\u5728spring ioc\u5bb9\u5668\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684class\u5b9a\u4e49!!", (Object[])new Object[0]);
        Object object = this.applicationContext.getBean(iocBeanClass);
        Validate.notNull((Object)object, (String)"\u672a\u5728spring ioc\u5bb9\u5668\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684bean\u5b9a\u4e49!!", (Object[])new Object[0]);
        try {
            this.invoke(context, object, currentServicableMethod.getSimpleMethodName(), argsClass, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e4) {
            if (e4 instanceof InvocationTargetException) {
                InvocationTargetException invocation = (InvocationTargetException)e4;
                Throwable throwableException = invocation.getTargetException();
                throw new IllegalArgumentException(throwableException.getMessage(), e4);
            }
            throw new IllegalArgumentException(e4.getMessage(), e4);
        }
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }

    private void invoke(InvokeProxyContext context, Object objBean, String simpleMethodName, Class<?>[] argsClass, Object[] argsValues) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = objBean.getClass().getMethod(simpleMethodName, argsClass);
        Object result = null;
        result = method.invoke(objBean, argsValues);
        if (result != null) {
            context.setResult(result);
        }
    }

    private void analysis(InvokeProxyContext context, InputParamsModel model, Object[] args, Class<?>[] argsClass, String userName, Set<ServicableMethodPropertyEntity> properties, Map<String, Object> assembleMap, InvokeParams conditionParams) throws ClassNotFoundException {
        for (ServicableMethodPropertyEntity pro : properties) {
            LOGGER.debug("****\u5f00\u59cb\u5904\u7406\u53c2\u6570*****\u53c2\u6570\u7c7b\u578b\uff1a" + pro.getParamType() + " \u53c2\u6570\u7d22\u5f15\uff1a" + pro.getPropertyIndex() + "  \u53c2\u6570\u9650\u5b9a\u540d\uff1a" + (StringUtils.isBlank((CharSequence)pro.getAnnonQualifiedName()) ? "\u65e0" : pro.getAnnonQualifiedName()));
            switch (pro.getParamType()) {
                case 2: {
                    args[pro.getPropertyIndex().intValue()] = userName;
                    argsClass[pro.getPropertyIndex().intValue()] = Class.forName(pro.getParamClass());
                    break;
                }
                case 3: {
                    int page = assembleMap.get("page") == null ? 0 : (Integer)assembleMap.remove("page");
                    int size = assembleMap.get("size") == null ? 50 : (Integer)assembleMap.remove("size");
                    PageRequest pageData = PageRequest.of((int)page, (int)size);
                    args[pro.getPropertyIndex().intValue()] = pageData;
                    argsClass[pro.getPropertyIndex().intValue()] = Class.forName(pro.getParamClass());
                    break;
                }
                case 4: {
                    JSONObject form = model.getFormData();
                    if (form != null) {
                        String modelType = pro.getModelType();
                        try {
                            Class<?> clz = context.getClassLoader().loadClass(modelType);
                            LOGGER.debug("<<<\u8f6c\u6362\u540e\u7684form\u53c2\u6570>>>\uff1a{}", (Object)form);
                            args[pro.getPropertyIndex().intValue()] = JSON.toJavaObject((JSON)form, clz);
                        }
                        catch (Exception e2) {
                            throw new IllegalArgumentException("json\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u7684json\u6570\u636e\u7c7b\u578b!!" + e2.getMessage());
                        }
                    } else {
                        args[pro.getPropertyIndex().intValue()] = null;
                    }
                    argsClass[pro.getPropertyIndex().intValue()] = context.getClassLoader().loadClass(pro.getModelType());
                    break;
                }
                case 5: {
                    args[pro.getPropertyIndex().intValue()] = conditionParams;
                    argsClass[pro.getPropertyIndex().intValue()] = InvokeParams.class;
                    break;
                }
                case 1: {
                    Object data = this.fetchObject(pro, assembleMap, properties);
                    if (data == null) {
                        args[pro.getPropertyIndex().intValue()] = null;
                    } else {
                        LOGGER.debug("<<<\u4f20\u5165\u7684\u53c2\u6570\u88ab\u5c01\u88c5\u540e\u7684\u7c7b\u578b\u4e3a>>>\uff1a{}", (Object)data.getClass().getName());
                        String jdkClassName = pro.getParamClass();
                        Class<?> jdkClass = ParamClassTypeConst.baseClassMapContainsKey(jdkClassName) != false ? ParamClassTypeConst.getBaseClass(jdkClassName) : Class.forName(jdkClassName);
                        String frontClassName = data.getClass().getName();
                        Class<?> frontClass = Class.forName(frontClassName);
                        if (jdkClass.isAssignableFrom(frontClass)) {
                            args[pro.getPropertyIndex().intValue()] = data;
                        } else if (!jdkClassName.contains(".") && jdkClassName.startsWith("[")) {
                            int n = 0;
                            int index = 0;
                            index = jdkClassName.indexOf(91);
                            while (index != -1) {
                                ++n;
                                index = jdkClassName.indexOf(91, index + 1);
                            }
                            if (n == 1) {
                                try {
                                    args = ParamsAnalysisUtil.unwapperArray(data, args, pro.getPropertyIndex(), jdkClassName);
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException("\u57fa\u672c\u7c7b\u578b\u6570\u7ec4\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!");
                                }
                            } else {
                                try {
                                    args = ParamsAnalysisUtil.unwapperArray2(data, args, pro.getPropertyIndex(), jdkClassName);
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException("\u4e8c\u7ef4\u57fa\u672c\u7c7b\u578b\u6570\u7ec4\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!");
                                }
                            }
                        } else {
                            if (!jdkClassName.contains(".") && !jdkClassName.startsWith("[")) {
                                try {
                                    args = ParamsAnalysisUtil.unwapper(data, args, pro.getPropertyIndex(), jdkClassName);
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException("java\u57fa\u672c\u7c7b\u578b\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!");
                                }
                            }
                            ArrayList source = null;
                            try {
                                source = (ArrayList)data;
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("\u4f20\u5165\u7684\u6570\u7ec4\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!");
                            }
                            Object oneDimensioArr = null;
                            Object twoDimensioArr = null;
                            boolean flag = false;
                            for (int x = 0; x < source.size(); ++x) {
                                if (source.get(x) == null) continue;
                                flag = source.get(x).getClass().getName().equals(ArrayList.class.getName());
                                break;
                            }
                            if (!flag) {
                                oneDimensioArr = Array.newInstance(Class.forName(jdkClassName.replaceAll("\\[L", "").replace(";", "")), source.size());
                                for (int index = 0; index < source.size() && source.get(index) != null; ++index) {
                                    Array.set(oneDimensioArr, index, source.get(index));
                                }
                                args[pro.getPropertyIndex().intValue()] = oneDimensioArr;
                            } else {
                                String twoDiClassName = jdkClassName.replaceFirst("\\[", "");
                                String oneDiClassName = jdkClassName.replaceAll("\\[\\[L", "").replace(";", "");
                                twoDimensioArr = Array.newInstance(Class.forName(twoDiClassName), source.size());
                                for (int index = 0; index < source.size() && source.get(index) != null; ++index) {
                                    Object oneDimensio = Array.newInstance(Class.forName(oneDiClassName), ((ArrayList)source.get(index)).size());
                                    ArrayList temp = (ArrayList)source.get(index);
                                    if (temp.isEmpty()) {
                                        Array.set(twoDimensioArr, index, Array.newInstance(Class.forName(oneDiClassName), 0));
                                        continue;
                                    }
                                    for (int x = 0; x < temp.size() && temp.get(x) != null; ++x) {
                                        Array.set(oneDimensio, x, temp.get(x));
                                        Array.set(twoDimensioArr, index, oneDimensio);
                                    }
                                }
                                args[pro.getPropertyIndex().intValue()] = twoDimensioArr;
                            }
                        }
                    }
                    argsClass[pro.getPropertyIndex().intValue()] = Boolean.TRUE.equals(ParamClassTypeConst.baseClassMapContainsKey(pro.getParamClass())) ? ParamClassTypeConst.getBaseClass(pro.getParamClass()) : Class.forName(pro.getParamClass());
                }
            }
        }
    }

    private Object fetchObject(ServicableMethodPropertyEntity pro, Map<String, Object> source, Set<ServicableMethodPropertyEntity> properties) {
        if (StringUtils.equals((CharSequence)"ignoreValidate", (CharSequence)pro.getAnnonQualifiedName())) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)pro.getAnnonQualifiedName())) {
            if (properties.size() == 1 && pro.getParamType() == 1 && source.values().size() == 1) {
                return source.values().iterator().next();
            }
            return source.remove(pro.getAnnonQualifiedName());
        }
        return null;
    }
}

