/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.service.image.FileUpdateService;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class FileServiceEffectiveTask {
    @Autowired
    private FileUpdateService fileUpdateService;

    @Scheduled(cron="* 30 0 * * ?")
    public void effectiveTask() {
        Date currentDate = new Date();
        List<OrdinaryFileEntity> oldFiles = this.fileUpdateService.findByEffectiveDate(currentDate);
        if (oldFiles == null || oldFiles.isEmpty()) {
            return;
        }
        List<String> oldFileIds = oldFiles.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.fileUpdateService.deleteFiles(oldFileIds.toArray(new String[0]));
    }
}

