/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.ButtonService;
import com.bizunited.platform.rbac.server.vo.ButtonVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/buttons"})
public class ButtonController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonController.class);
    @Autowired
    private ButtonService buttonService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u6309\u94ae", notes="\u521b\u5efa\u6309\u94ae\uff0c\u5fc5\u987b\u8981\u4f20\u9012\u83dc\u5355\u5bf9\u8c61\uff0c\u5e76\u4e14\u83dc\u5355\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a")
    public ResponseModel create(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody ButtonVo button) {
        try {
            ButtonVo result = this.buttonService.create(button);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"batchCreate"})
    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u6309\u94ae", notes="\u521b\u5efa\u6309\u94ae\uff0c\u5fc5\u987b\u8981\u4f20\u9012\u83dc\u5355\u5bf9\u8c61\uff0c\u5e76\u4e14\u83dc\u5355\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a")
    public ResponseModel batchCreate(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody Set<ButtonVo> buttons) {
        try {
            this.buttonService.batchCreate(buttons);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u4fee\u6539\u6309\u94ae", notes="\u4fee\u6539\u6309\u94ae")
    public ResponseModel update(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody ButtonVo button) {
        try {
            ButtonVo result = this.buttonService.update(button);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"batchDelete"})
    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u5220\u9664\u6309\u94ae")
    public ResponseModel batchDelete(@RequestParam(name="ids") @ApiParam(name="ids", value="\u6307\u5b9a\u7684\u6309\u94aeid\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] ids) {
        try {
            this.buttonService.batchDelete(ids);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u6309\u94ae", notes="\u6839\u636eid\u5220\u9664\u6309\u94ae")
    public ResponseModel deleteById(@ApiParam(name="id", value="\u6309\u94aeID", required=true) @PathVariable(value="id") String id) {
        try {
            this.buttonService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCompetenceId"})
    @ApiOperation(value="\u6839\u636e\u83dc\u5355ID\u67e5\u8be2\u6309\u94ae", notes="\u6839\u636e\u83dc\u5355ID\u67e5\u8be2\u6309\u94ae")
    public ResponseModel findByCompetenceId(@ApiParam(name="competenceId", value="\u6309\u94aeID", required=true) @RequestParam(value="competenceId") String competenceId) {
        try {
            Set result = this.buttonService.findByCompetenceId(competenceId);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByRoleCode"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272code\u67e5\u8be2\u5173\u8054\u7684\u6309\u94ae", notes="\u6839\u636e\u89d2\u8272code\u67e5\u8be2\u5173\u8054\u7684\u6309\u94ae")
    public ResponseModel findByRoleCode(@ApiParam(name="roleCode", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam(value="roleCode") String roleCode) {
        try {
            Set result = this.buttonService.findByRoleCode(roleCode);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5efa\u7acb\u6307\u5b9a\u6309\u94ae\u548c\u6307\u5b9a\u63a5\u53e3\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/bindCompetences"})
    public ResponseModel bindCompetences(@RequestParam(name="buttonId") @ApiParam(name="buttonId", value="\u6307\u5b9a\u7684\u6309\u94ae\u7f16\u53f7\u4fe1\u606f") String buttonId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u63a5\u53e3\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.buttonService.bindCompetences(buttonId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u6307\u5b9a\u6309\u94ae\u548c\u6307\u5b9a\u63a5\u53e3\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindCompetences"})
    public ResponseModel unbindCompetences(@RequestParam(name="buttonId") @ApiParam(name="buttonId", value="\u6307\u5b9a\u7684\u6309\u94ae\u7f16\u53f7\u4fe1\u606f") String buttonId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u63a5\u53e3\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.buttonService.unbindCompetences(buttonId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u7684\u6309\u94ae\u6743\u9650")
    @GetMapping(value={"findByUserId"})
    public ResponseModel findByUserId(@RequestParam(name="userId") @ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237\u7684\u7f16\u53f7\u4fe1\u606f") String userId) {
        try {
            Set buttonVos = this.buttonService.findByUserId(userId);
            return this.buildHttpResultW(buttonVos, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCurrentUser"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u6309\u94ae\u6743\u9650", notes="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u6309\u94ae\u6743\u9650,\u5982\u679c\u5f53\u524d\u767b\u5f55\u7528\u6237\u6709\u5ffd\u7565\u6743\u9650\u7684\u6309\u94ae\uff0c\u90a3\u5c31\u8fd4\u56de\u6240\u6709\u7684\u6743\u9650\u6309\u94ae")
    public ResponseModel findByCurrentUser() {
        try {
            Principal principal = super.getPrincipal();
            Set buttonVos = this.buttonService.findByCurrentUser(principal);
            return this.buildHttpResultW(buttonVos, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6309\u94aeid\u67e5\u8be2\u6309\u94ae\u4fe1\u606f")
    @GetMapping(value={"findDateilsById"})
    public ResponseModel findDateilsById(@RequestParam(name="buttonId") @ApiParam(name="buttonId", value="\u6307\u5b9a\u7684\u6309\u94ae\u7684\u7f16\u53f7\u4fe1\u606f") String buttonId) {
        try {
            ButtonVo buttonVo = this.buttonService.findDateilsById(buttonId);
            return this.buildHttpResultW(buttonVo, "competences", "competence", "roles");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

