/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/position"})
public class PositionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionController.class);
    @Autowired
    private PositionService positionService;

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u7528\u6237\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="name", value="\u540d\u79f0") String name, @ApiParam(name="code", value="\u7f16\u7801") String code, @ApiParam(name="tstatus", value="\u72b6\u6001") Integer tstatus, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page page = this.positionService.findByConditions(code, name, tstatus, pageable);
            return this.buildHttpResultW(page, "organization", "users", "roles", "parent", "children");
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5c97\u4f4d\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u5305\u62ec\u76f8\u5173\u7ec4\u7ec7\u3001\u89d2\u8272\u3001\u7528\u6237\u7b49")
    @RequestMapping(value={"/find/{positionId}"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@PathVariable(value="positionId") String positionId) {
        try {
            PositionVo positionVo = this.positionService.findDetailsById(positionId);
            return this.buildHttpResultW(positionVo, "organization", "users", "roles");
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6dfb\u52a0\u5c97\u4f4d")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f") @RequestBody PositionVo position) {
        try {
            PositionVo positionVo = this.positionService.create(position);
            return this.buildHttpResultW(positionVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5c97\u4f4d")
    @RequestMapping(value={"update"}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f") @RequestBody PositionVo position) {
        try {
            PositionVo positionVo = this.positionService.update(position);
            return this.buildHttpResultW(positionVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5c97\u4f4d\u72b6\u6001\uff08\u542f\u7528\u7981\u7528\uff09")
    @RequestMapping(value={"updateStatus/{positionId}"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatus(@PathVariable(value="positionId") String positionId) {
        try {
            PositionVo positionVo = this.positionService.updateStatus(positionId);
            return this.buildHttpResultW(positionVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ed1\u5b9a\u6307\u5b9a\u7684\u5c97\u4f4d\u548c\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={"/bindOrgAndPosition"}, method={RequestMethod.PATCH})
    public ResponseModel bindOrgAndPosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="orgId") @ApiParam(name="orgId", value="\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\uff08orgId\uff09") String orgId) {
        try {
            this.positionService.bindOrgAndPosition(orgId, positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u6307\u5b9a\u7684\u5c97\u4f4d\u548c\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={"/unbindOrgAndPosition"}, method={RequestMethod.PATCH})
    public ResponseModel unbindOrgAndPosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="orgId") @ApiParam(name="orgId", value="\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\uff08orgId\uff09") String orgId) {
        try {
            this.positionService.unbindOrgAndPosition(orgId, positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u4e00\u4e2a\u5c97\u4f4d\u548c\u6307\u5b9a\u7684\u591a\u4e2a\u89d2\u8272\u5f62\u6210\u7ed1\u5b9a\u5173\u7cfb")
    @RequestMapping(value={"/bindRolesAndPosition"}, method={RequestMethod.PATCH})
    public ResponseModel bindRolesAndPosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u5f53\u524d\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="roleIds") @ApiParam(name="roleIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u89d2\u8272\u6570\u636e\u7f16\u53f7\uff08roleId\uff09") String[] roleIds) {
        try {
            this.positionService.bindRolesAndPosition(Arrays.asList(roleIds), positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u591a\u4e2a\u89d2\u8272\u4e0e\u67d0\u4e00\u6307\u5b9a\u7684\u5c97\u4f4d")
    @RequestMapping(value={"/unbindRolesAndPosition"}, method={RequestMethod.PATCH})
    public ResponseModel unbindRolesAndPosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="roleIds") @ApiParam(name="roleIds", value="\u6307\u5b9a\u7684\u89d2\u8272ID") String[] roleIds) {
        try {
            this.positionService.unbindRolesAndPosition(Arrays.asList(roleIds), positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u4e00\u4e2a\u5c97\u4f4d\u548c\u6307\u5b9a\u7684\u591a\u4e2a\u7528\u6237\u5f62\u6210\u7ed1\u5b9a\u5173\u7cfb")
    @RequestMapping(value={"/bindUsersAndPosition"}, method={RequestMethod.PATCH})
    public ResponseModel bindUsers(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u5f53\u524d\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="userIds") @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.positionService.bindUsersAndPosition(Arrays.asList(userIds), positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u591a\u4e2a\u7528\u6237\u4e0e\u67d0\u4e00\u6307\u5b9a\u7684\u5c97\u4f4d")
    @RequestMapping(value={"/unbindUsersAndPosition"}, method={RequestMethod.PATCH})
    public ResponseModel unbindUsersAndPosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="userIds") @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u7528\u6237ID") String[] userIds) {
        try {
            this.positionService.unbindUsersAndPosition(Arrays.asList(userIds), positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u67e5\u8be2\u7528\u6237\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f")
    @RequestMapping(value={"/findByUserId"}, method={RequestMethod.GET})
    public ResponseModel findByUserId(@ApiParam(name="userId", value="\u7528\u6237id") @RequestParam(value="userId") String userId) {
        try {
            List position = this.positionService.findByUserId(userId);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u7528\u6237\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f")
    @RequestMapping(value={"/findByIds"}, method={RequestMethod.POST})
    public ResponseModel findByIds(@RequestBody List<String> ids) {
        try {
            Set position = this.positionService.findByIds(ids);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCode"})
    @ApiOperation(value="\u6839\u636e\u5c97\u4f4d\u7f16\u7801\u67e5\u8be2")
    public ResponseModel findByCode(@RequestParam @ApiParam(value="\u5c97\u4f4d\u7f16\u7801") String code) {
        try {
            PositionVo position = this.positionService.findByCode(code);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"changePosition"})
    @ApiOperation(value="\u5207\u6362\u5c97\u4f4d")
    public ResponseModel changePosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u5c97\u4f4did", required=true) String positionId, @RequestParam(name="userId") @ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237ID", required=true) String userId) {
        try {
            UserVo userVo = this.positionService.changePosition(positionId, userId);
            return this.buildHttpResultW(userVo, "roles", "positions");
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findAllByConditions"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u6240\u6709\u5c97\u4f4d")
    public ResponseModel findAllByConditions(@RequestParam(required=false) @ApiParam(value="\u72b6\u6001") Integer status) {
        try {
            PositionVo position = new PositionVo();
            position.setTstatus(status);
            List positions = this.positionService.findAllByConditions(position);
            return this.buildHttpResultW(positions, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

