/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dataViewVerticals"})
public class DataViewAuthVerticalController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthVerticalController.class);
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;

    @ApiOperation(value="\u521b\u5efa\u6570\u636e\u89c6\u56fe\u7eb5\u5411\u6743\u9650")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="authVerticals", value="\u521b\u5efa\u6570\u636e\u89c6\u56fe\u7eb5\u5411\u6743\u9650") Set<DataViewAuthVerticalEntity> authVerticals) {
        try {
            Set<DataViewAuthVerticalEntity> current = this.dataViewAuthVerticalService.create(authVerticals);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u89c6\u56fe\u7eb5\u5411\u6743\u9650")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="authVerticals", value="\u66f4\u65b0\u6570\u636e\u89c6\u56fe\u7eb5\u5411\u6743\u9650") Set<DataViewAuthVerticalEntity> authVerticals, @RequestParam(value="dataViewId") @ApiParam(name="dataViewId", value="\u6570\u636e\u89c6\u56feID") String dataViewId) {
        try {
            Set<DataViewAuthVerticalEntity> current = this.dataViewAuthVerticalService.update(authVerticals, dataViewId);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u5173\u8054\u7684 \u5bf9\u5e94\u7684\u89c6\u56fe\u8fdb\u884c\u67e5\u8be2")
    @RequestMapping(value={"/findDetailsByDataView"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByDataView(@RequestParam(value="dataView") @ApiParam(value="\u5173\u8054\u7684 \u5bf9\u5e94\u7684\u89c6\u56fe") String dataView) {
        try {
            Set<DataViewAuthVerticalEntity> result = this.dataViewAuthVerticalService.findDetailsByDataViewCode(dataView);
            return this.buildHttpResultW(result, new String[]{"authRelations", "authRelations.authVertical", "displayFields", "dataView", "field", "authRelations.relation"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            DataViewAuthVerticalEntity result = this.dataViewAuthVerticalService.findDetailsById(id);
            return this.buildHttpResultW(result, "authRelations", "authRelations.authVertical", "displayFields", "dataView", "field");
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

