/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.repository.internal.DynamicTaskSchedulerRepositoryCustom;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="DynamicTaskSchedulerRepository")
public interface DynamicTaskSchedulerRepository
extends JpaRepository<DynamicTaskSchedulerEntity, String>,
JpaSpecificationExecutor<DynamicTaskSchedulerEntity>,
DynamicTaskSchedulerRepositoryCustom {
    @Query(value="from DynamicTaskSchedulerEntity dts where dts.tstatus = :tstatus AND dts.applicationName = :applicationName AND dts.workingStatus in (:workingStatuses) order by dts.taskCode ")
    public Set<DynamicTaskSchedulerEntity> findByTstatusAndWorkingStatusAndApplicationName(@Param(value="tstatus") int var1, @Param(value="workingStatuses") int[] var2, @Param(value="applicationName") String var3);

    public Set<DynamicTaskSchedulerEntity> findByInvokeTypeAndApplicationName(@Param(value="invokeType") int var1, @Param(value="applicationName") String var2);

    @Query(value="from DynamicTaskSchedulerEntity dts where dts.tstatus = :tstatus AND dts.applicationName = :applicationName order by dts.taskCode ")
    public Set<DynamicTaskSchedulerEntity> findByTstatusAndApplicationName(@Param(value="tstatus") int var1, @Param(value="applicationName") String var2);

    @Query(value="from DynamicTaskSchedulerEntity dts where dts.applicationName = :applicationName AND dts.workingStatus in (:workingStatuses) order by dts.taskCode ")
    public Set<DynamicTaskSchedulerEntity> findByWorkingStatusAndApplicationName(@Param(value="workingStatuses") int[] var1, @Param(value="applicationName") String var2);

    @Query(value="from DynamicTaskSchedulerEntity dts left join fetch dts.modifyUser m left join fetch dts.createUser c where dts.taskCode = :taskCode and dts.applicationName = :applicationName ")
    public DynamicTaskSchedulerEntity findByTaskCodeAndApplicationName(@Param(value="taskCode") String var1, @Param(value="applicationName") String var2);

    @Query(value="from DynamicTaskSchedulerEntity dts where dts.projectName = '' OR dts.projectName IS NULL order by dts.createTime desc ")
    public Set<DynamicTaskSchedulerEntity> findByBlankProjectName();

    @Modifying
    @Query(value="update engine_dynamic_task set working_status = 1 , t_status = 0 where application_name = :applicationName and task_code in (:taskCodes)", nativeQuery=true)
    public void updateInvalidByTaskCode(@Param(value="taskCodes") String[] var1, @Param(value="applicationName") String var2);

    @Modifying
    @Query(value="update engine_dynamic_task set working_status = 2 , t_status = 1 where  application_name = :applicationName and task_code in (:taskCodes)", nativeQuery=true)
    public void updateRunningByTaskCode(@Param(value="taskCodes") String[] var1, @Param(value="applicationName") String var2);

    @Query(value="from DynamicTaskSchedulerEntity dts where dts.projectName = :projectName order by dts.createTime desc ")
    public Set<DynamicTaskSchedulerEntity> findByProjectName(@Param(value="projectName") String var1);
}

