/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

class SQLOrderbyAnalysis {
    private SQLOrderbyAnalysis() {
    }

    static void buildSQLConditionsOrderBy(Set<DataViewFilterEntity> filters, InvokeParams params, Map<SQLCorrelationEnum, Object> map) {
        if (CollectionUtils.isEmpty(filters) || CollectionUtils.isEmpty(map)) {
            return;
        }
        Set orderBySets = filters.stream().filter(e -> {
            String fieldName = e.getField().getFieldName();
            InvokeOperations model = params.get(fieldName);
            return params.containsKey(fieldName) && StringUtils.isNotBlank((CharSequence)model.getSortType());
        }).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(orderBySets)) {
            return;
        }
        ArrayList orderByLists = new ArrayList();
        HashMap<Integer, DataViewFilterEntity> sortMap = new HashMap<Integer, DataViewFilterEntity>();
        ArrayList<Integer> sortIndexList = new ArrayList<Integer>();
        for (DataViewFilterEntity dataViewFilterEntity : orderBySets) {
            InvokeOperations model = params.get(dataViewFilterEntity.getField().getFieldName());
            Integer sortIndex = model.getSortIndex();
            sortIndexList.add(sortIndex);
            sortMap.put(sortIndex, dataViewFilterEntity);
        }
        Collections.sort(sortIndexList);
        for (Integer n : sortIndexList) {
            orderByLists.add(sortMap.get(n));
        }
        StringBuilder orderByBuilder = new StringBuilder(" order by ");
        for (DataViewFilterEntity e3 : orderByLists) {
            String fieldName = e3.getField().getFieldName();
            InvokeOperations model = params.get(fieldName);
            model.setOprtType(e3.getOpType());
            model.setParamName(fieldName);
            orderByBuilder.append(String.format(" %s.%s %s,", "s01y01s01", model.getParamName(), model.getSortType()));
        }
        String string = StringUtils.left((String)orderByBuilder.toString(), (int)(orderByBuilder.toString().length() - 1));
        String oldVal = map.remove((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        map.putIfAbsent(SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, oldVal);
        String newVal = oldVal + string;
        map.put(SQLCorrelationEnum.RESULT_SQL, newVal);
    }
}

