/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.common.constant.ParamClassTypeConst;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import com.bizunited.platform.core.repository.internal.PageRepositoryImpl;
import com.bizunited.platform.core.repository.internal.ServicableMethodRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ServicableMethodRepositoryImpl")
public class ServicableMethodRepositoryImpl
implements ServicableMethodRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String USED_SCOPE = "usedScope";
    private static final String INTERFACE_NAME = "interfaceName";
    private static final String SIMPLE_METHOD_NAME = "simpleMethodName";
    private static final String RETURN_CLASS_NAME = "returnClassName";
    private static final String PROPERTY_CLASS_NAME = "propertyClassName";
    private static final String DESCRIPTION = "description";

    @Override
    public Page<ServicableMethodEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        Object description;
        Object propertyClassName;
        Object returnClassName;
        Object simpleMethodName;
        Object interfaceName;
        String projectName;
        StringBuilder hql = new StringBuilder("select distinct sm from ServicableMethodEntity sm left join fetch sm.properties smp where 1=1 ");
        StringBuilder countSql = new StringBuilder("select count(*) from ServicableMethodEntity sm where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object usedScope = conditions.get(USED_SCOPE);
        if (usedScope != null) {
            condition.append(" and sm.usedScope = :usedScope ");
            parameters.put(USED_SCOPE, usedScope);
        }
        if (StringUtils.isNotBlank((CharSequence)(projectName = (String)conditions.get("projectName")))) {
            condition.append(" and sm.projectName = :projectName");
            parameters.put("projectName", projectName);
        } else {
            condition.append(" and (sm.projectName = '' or sm.projectName is null)");
        }
        Object name = conditions.get("name");
        if (name != null) {
            condition.append(" and sm.name like CONCAT('%', CONCAT(:name, '%')) ");
            parameters.put("name", name);
        }
        if ((interfaceName = conditions.get(INTERFACE_NAME)) != null) {
            condition.append(" and sm.interfaceName = :interfaceName ");
            parameters.put(INTERFACE_NAME, interfaceName);
        }
        if ((simpleMethodName = conditions.get(SIMPLE_METHOD_NAME)) != null) {
            condition.append(" and sm.simpleMethodName = :simpleMethodName ");
            parameters.put(SIMPLE_METHOD_NAME, simpleMethodName);
        }
        if ((returnClassName = conditions.get(RETURN_CLASS_NAME)) != null) {
            condition.append(" and sm.returnClassName = :returnClassName ");
            parameters.put(RETURN_CLASS_NAME, returnClassName);
        }
        if ((propertyClassName = conditions.get(PROPERTY_CLASS_NAME)) != null) {
            condition.append(" and smp.paramClass = :propertyClassName ");
            parameters.put(PROPERTY_CLASS_NAME, propertyClassName);
        }
        Object object = description = conditions != null ? conditions.get(DESCRIPTION) : null;
        if (description != null) {
            condition.append(" AND sm.description like CONCAT('%',:description,'%') ");
            parameters.put(DESCRIPTION, description);
        }
        hql.append((CharSequence)condition).append(" order by sm.name desc ");
        countSql.append((CharSequence)condition);
        Page page = this.queryByConditions(this.entityManager, hql.toString(), countSql.toString(), parameters, pageable, false, null);
        this.transParamClassType(page.getContent());
        return page;
    }

    private List<ServicableMethodEntity> transParamClassType(List<ServicableMethodEntity> resutls) {
        for (ServicableMethodEntity method : resutls) {
            if (method.getProperties() == null || method.getProperties().size() <= 0) continue;
            for (ServicableMethodPropertyEntity param : method.getProperties()) {
                if (!ParamClassTypeConst.baseClassMapContainsKey(param.getParamClass()).booleanValue()) continue;
                param.setParamClass(ParamClassTypeConst.getBaseClass(param.getParamClass()).toString());
            }
        }
        return resutls;
    }
}

