/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.repository.dataview.DataSourceRepository;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DataSourceEntityServiceImpl")
public class DataSourceServiceImpl
implements DataSourceService {
    @Autowired
    private DataSourceRepository dataSourceRepository;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public DataSourceEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataSourceRepository.findById(id).orElse(null);
    }

    @Override
    public DataSourceEntity findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataSourceRepository.findDetailsByCode(code);
    }

    @Override
    public List<DataSourceEntity> findByStatus(Integer status) {
        String projectName = this.platformContext.getAppName();
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            return this.dataSourceRepository.findByTstatusAndProjectName(status, projectName);
        }
        return this.dataSourceRepository.findByTstatusAndBlankProjectName(status);
    }

    @Override
    public List<DataSourceEntity> findAll() {
        String projectName = this.platformContext.getAppName();
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            return this.dataSourceRepository.findByProjectName(projectName);
        }
        return this.dataSourceRepository.findByBlankProjectName();
    }
}

