/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.ButtonEntity;
import com.bizunited.platform.core.entity.CompetenceEntity;
import com.bizunited.platform.core.repository.ButtonRepository;
import com.bizunited.platform.core.repository.CompetenceRepository;
import com.bizunited.platform.core.service.init.InitProcessService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCompetenceInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompetenceInitProcess.class);
    @Autowired(required=false)
    private ButtonRepository buttonRepository;
    @Autowired(required=false)
    protected CompetenceRepository competenceRepository;

    @Override
    public int sort() {
        return 0;
    }

    public boolean doProcess(String resource) {
        long count = this.competenceRepository.countByResource(resource);
        return count == 0L;
    }

    protected void initCompetences(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        if (this.competenceRepository == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line = bufferedReader.readLine();
            while (line != null) {
                sb.append(line);
                line = bufferedReader.readLine();
            }
        }
        String json = sb.toString();
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.warn("\u521d\u59cb\u5316\u83dc\u5355json\u4e3a\u7a7a\uff01\uff01");
            return;
        }
        JSONArray competences = JSON.parseArray((String)json);
        this.initCompetences(null, competences);
    }

    protected void initCompetences(CompetenceEntity parent, JSONArray competences) {
        if (CollectionUtils.isEmpty((Collection)competences)) {
            return;
        }
        for (Object object : competences) {
            JSONObject competenceJson = JSON.parseObject((String)object.toString());
            CompetenceEntity competence = (CompetenceEntity)JSON.parseObject((String)competenceJson.toJSONString(), CompetenceEntity.class);
            CompetenceEntity oldCompetence = parent != null ? this.competenceRepository.findByCommentAndViewItemAndParent(competence.getComment(), 1, parent.getId()) : this.competenceRepository.findByCommentAndViewItemAndNullParent(competence.getComment(), 1);
            if (oldCompetence == null) {
                competence.setCreateDate(new Date());
                competence.setModifyDate(new Date());
                competence.setTstatus(1);
                competence.setParent(parent);
                this.competenceRepository.save(competence);
                oldCompetence = competence;
            }
            this.initButtons(oldCompetence, competence.getButtons());
            if (!competenceJson.containsKey((Object)"competences")) continue;
            this.initCompetences(oldCompetence, competenceJson.getJSONArray("competences"));
        }
    }

    private void initButtons(CompetenceEntity competence, Set<ButtonEntity> buttons) {
        if (this.buttonRepository == null || CollectionUtils.isEmpty(buttons)) {
            return;
        }
        for (ButtonEntity button : buttons) {
            Set<CompetenceEntity> competencesJson = button.getCompetences();
            ButtonEntity oldButton = this.buttonRepository.findByCode(button.getCode());
            if (oldButton == null) {
                button.setCompetence(competence);
                button.setSystem(true);
                button.setCreateTime(new Date());
                button.setModifyTime(new Date());
                button.setCompetences(null);
                this.buttonRepository.save(button);
            } else {
                Validate.isTrue((boolean)competence.getId().equals(oldButton.getCompetence().getId()), (String)"\u91cd\u590d\u7684\u6309\u94ae\u6bd4\u7f16\u7801\u3010%s\u3011,\u8bf7\u68c0\u67e5", (Object[])new Object[]{button.getCode()});
                button = oldButton;
            }
            this.initButtonCompetences(button, competencesJson);
        }
    }

    private void initButtonCompetences(ButtonEntity button, Set<CompetenceEntity> competencesJson) {
        if (CollectionUtils.isEmpty(competencesJson)) {
            return;
        }
        if (button == null) {
            return;
        }
        HashMap<String, CompetenceEntity> competencesMap = new HashMap<String, CompetenceEntity>();
        Set<CompetenceEntity> buttonCompetences = button.getCompetences();
        if (buttonCompetences == null) {
            buttonCompetences = new HashSet<CompetenceEntity>();
            button.setCompetences(buttonCompetences);
        } else {
            for (CompetenceEntity entity : buttonCompetences) {
                competencesMap.put(entity.getId(), entity);
            }
        }
        for (CompetenceEntity competence : competencesJson) {
            CompetenceEntity oldCompetence = this.competenceRepository.findByResourceAndMethods(competence.getResource(), competence.getMethods());
            if (oldCompetence == null) {
                LOGGER.warn("\u672a\u627e\u5230\u63a5\u53e3\u8def\u5f84\u3010{}\u3011,\u8bf7\u6c42\u65b9\u6cd5\u3010{}\u3011\uff0c\u8bf7\u68c0\u67e5!", (Object)competence.getResource(), (Object)competence.getMethods());
                continue;
            }
            if (competencesMap.containsKey(oldCompetence.getId())) continue;
            buttonCompetences.add(oldCompetence);
        }
        this.buttonRepository.save(button);
    }
}

