/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import com.bizunited.platform.core.repository.ServicableMethodPropertyRepository;
import com.bizunited.platform.core.repository.ServicableMethodRepository;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodPropertyService;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="KuiperServiceMethodServiceImpl")
public class ServicableMethodServiceImpl
implements ServicableMethodService {
    @Autowired
    private ServicableMethodRepository servicableMethodRepository;
    @Autowired
    private ServicableMethodPropertyRepository servicableMethodPropertyRepository;
    @Autowired
    private ServicableMethodPropertyService servicableMethodPropertyService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public void create(ServicableMethodEntity serviceMethod) {
        ArrayList<ServicableMethodPropertyEntity> properties;
        String name = serviceMethod.getName();
        Validate.notBlank((CharSequence)name, (String)"\u672a\u53d1\u73b0KuiperServiceMethod\u4e2d\u7684name\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String desc = serviceMethod.getDescription();
        Validate.notBlank((CharSequence)desc, (String)"\u672a\u53d1\u73b0KuiperServiceMethod\u4e2d\u7684desc\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String methodName = serviceMethod.getMethodName();
        Validate.notBlank((CharSequence)methodName, (String)"\u672a\u53d1\u73b0\u65b9\u6cd5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String interfaceName = serviceMethod.getInterfaceName();
        Validate.notBlank((CharSequence)interfaceName, (String)"\u672a\u53d1\u73b0\u63a5\u53e3\u65b9\u6cd5\u5b9a\u4e49\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String returnClassName = serviceMethod.getReturnClassName();
        Validate.notBlank((CharSequence)returnClassName, (String)"\u672a\u53d1\u73b0\u63a5\u53e3\u65b9\u6cd5\u5b9a\u4e49\u8fd4\u56de\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String simpleMethodName = serviceMethod.getSimpleMethodName();
        Validate.notBlank((CharSequence)simpleMethodName, (String)"\u672a\u53d1\u73b0\u65b9\u6cd5\u7b80\u79f0\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.servicableMethodRepository.saveAndFlush(serviceMethod);
        if (serviceMethod.getProperties() != null && !(properties = new ArrayList<ServicableMethodPropertyEntity>(serviceMethod.getProperties())).isEmpty()) {
            for (ServicableMethodPropertyEntity serviceMethodProperty : properties) {
                serviceMethodProperty.setServiceMethod(serviceMethod);
                this.servicableMethodPropertyService.create(serviceMethodProperty);
            }
        }
    }

    @Override
    @Transactional
    public void deleteServiceMethodAndProperties() {
        String appName = this.platformContext.getAppName();
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            this.servicableMethodPropertyRepository.deleteByProjectName(appName);
            this.servicableMethodRepository.deleteByProjectName(appName);
            return;
        }
        this.servicableMethodPropertyRepository.deleteByBlankProjectName();
        this.servicableMethodRepository.deleteByBlankProjectName();
    }

    @Override
    public Page<ServicableMethodEntity> findByConditions(Pageable pageable, String name, String description, String interfaceName, String simpleMethodName, String returnClassName, String propertyClassName, String usedScope) {
        Validate.notBlank((CharSequence)usedScope, (String)"\u670d\u52a1\u6e90\u7684\u5e94\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("usedScope", usedScope);
        conditions.put("projectName", this.platformContext.getAppName());
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            conditions.put("description", description);
        }
        if (StringUtils.isNotBlank((CharSequence)interfaceName)) {
            conditions.put("interfaceName", interfaceName);
        }
        if (StringUtils.isNotBlank((CharSequence)simpleMethodName)) {
            conditions.put("simpleMethodName", simpleMethodName);
        }
        if (StringUtils.isNotBlank((CharSequence)returnClassName)) {
            conditions.put("returnClassName", returnClassName);
        }
        if (StringUtils.isNotBlank((CharSequence)propertyClassName)) {
            conditions.put("propertyClassName", propertyClassName);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.servicableMethodRepository.findByConditions(pageable, conditions);
    }

    @Override
    public ServicableMethodEntity findDetailsByName(String name) {
        Validate.notBlank((CharSequence)name, (String)"\u670d\u52a1\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.servicableMethodRepository.queryDetailsByName(name);
    }

    @Override
    public ServicableMethodEntity findByName(String name) {
        Validate.notBlank((CharSequence)name, (String)"\u670d\u52a1\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ServicableMethodEntity entity = this.servicableMethodRepository.queryByName(name);
        Validate.notNull((Object)entity, (String)"\u6839\u636e\u670d\u52a1name\u503c\uff0c\u672a\u83b7\u53d6\u5230\u670d\u52a1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return entity;
    }

    @Override
    public Object writeInvoke(Map<String, Object> params) throws InvokeProxyException {
        InvokeProxy writeServicableProxy = (InvokeProxy)this.applicationContext.getBean("WriteServicableProxy", InvokeProxy.class);
        Object result = null;
        if (params != null && !params.isEmpty()) {
            result = writeServicableProxy.doHandle(params);
        }
        return result;
    }

    @Override
    public Object readInvoke(Map<String, Object> params) throws InvokeProxyException {
        InvokeProxy writeServicableProxy = (InvokeProxy)this.applicationContext.getBean("ReadServicableProxy", InvokeProxy.class);
        Object result = null;
        if (params != null && !params.isEmpty()) {
            result = writeServicableProxy.doHandle(params);
        }
        return result;
    }
}

