/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UserGroupEntity;
import com.bizunited.platform.core.repository.OrganizationRepository;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserGroupRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.ButtonService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.ButtonVo;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.CollectionUtils;

public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private UserRepository userService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PositionService positionService;
    @Autowired
    @Lazy
    private ButtonService buttonService;
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;
    @Value(value="${rbac.roles.deleteDeny}")
    private String[] deleteDenys;

    @Transactional
    public RoleVo create(RoleVo role) {
        this.validateRoleBeforeAdd(role);
        RoleEntity roleEntity = this.nebulaToolkitService.copyObjectByWhiteList(role, RoleEntity.class, HashSet.class, ArrayList.class, "parent");
        this.roleRepository.saveAndFlush(roleEntity);
        role.setId(roleEntity.getId());
        return role;
    }

    @Transactional
    public RoleVo update(RoleVo role) {
        Validate.notNull((Object)role, (String)"role mssage not null", (Object[])new Object[0]);
        String roleId = role.getId();
        String updateComment = role.getComment();
        Validate.notEmpty((CharSequence)roleId, (String)"role id not empty!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"role not found", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)op.get();
        String currentName = currentRole.getRoleName();
        for (String deleteDeny : this.deleteDenys) {
            if (!StringUtils.equals((CharSequence)currentName, (CharSequence)deleteDeny)) continue;
            throw new AccessDeniedException("\u8fd9\u4e2a\u89d2\u8272\u4e3a\u7cfb\u7edf\u7279\u5b9a\u9ed8\u8ba4\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        if (!StringUtils.isBlank((CharSequence)updateComment)) {
            currentRole.setComment(updateComment);
        }
        if (role.getParent() != null) {
            Validate.notBlank((CharSequence)role.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            RoleEntity parentRole = this.roleRepository.findById(role.getParent().getId()).orElse(null);
            Validate.notNull((Object)parentRole, (String)"\u672a\u627e\u5230\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272", (Object[])new Object[0]);
            currentRole.setParent(parentRole);
        } else {
            currentRole.setParent(null);
        }
        this.roleRepository.saveAndFlush(currentRole);
        HashSet<String> roleStack = new HashSet<String>();
        roleStack.add(currentRole.getId());
        this.handleCircular(currentRole, roleStack);
        return role;
    }

    private void handleCircular(RoleEntity parent, Set<String> roleStack) {
        if (CollectionUtils.isEmpty(parent.getChildren())) {
            return;
        }
        for (RoleEntity roleEntity : parent.getChildren()) {
            Validate.isTrue((!roleStack.contains(roleEntity.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            roleStack.add(roleEntity.getId());
            this.handleCircular(roleEntity, roleStack);
        }
    }

    @Transactional
    public RoleVo disable(String roleId) {
        Validate.notEmpty((CharSequence)roleId, (String)"role id not be found!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)op.get();
        for (String deleteDeny : this.deleteDenys) {
            if (!StringUtils.equals((CharSequence)currentRole.getRoleName(), (CharSequence)deleteDeny)) continue;
            throw new AccessDeniedException("the role not allow be disable\uff01");
        }
        currentRole.setTstatus(0);
        this.roleRepository.save(currentRole);
        return this.nebulaToolkitService.copyObjectByWhiteList(currentRole, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public RoleVo enable(String roleId) {
        Validate.notEmpty((CharSequence)roleId, (String)"role id not be found!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)op.get();
        currentRole.setTstatus(1);
        this.roleRepository.save(currentRole);
        return this.nebulaToolkitService.copyObjectByWhiteList(currentRole, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateRoleBeforeAdd(RoleVo role) {
        Validate.notNull((Object)role, (String)"role input object not be null!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)role.getRoleName(), (String)"role name not be null!", (Object[])new Object[0]);
        role.setRoleName(role.getRoleName().toUpperCase());
        RoleEntity oldRole = this.roleRepository.findByRoleName(role.getRoleName());
        Validate.isTrue((oldRole == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u8bbe\u5b9a\u7684\u89d2\u8272\u540d\u79f0\uff08role name\uff09\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362!", (Object[])new Object[0]);
        oldRole = this.roleRepository.findByRoleCode(role.getRoleCode());
        Validate.isTrue((oldRole == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u8bbe\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\uff08role code\uff09\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362!", (Object[])new Object[0]);
        Date currentTime = new Date();
        role.setCreateDate(currentTime);
        if (StringUtils.isBlank((CharSequence)role.getComment())) {
            role.setComment("[\u672a\u586b\u5199]");
        }
        role.setTstatus(Integer.valueOf(1));
        if (role.getParent() != null) {
            Validate.notBlank((CharSequence)role.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            RoleEntity parentRole = this.roleRepository.findById(role.getParent().getId()).orElse(null);
            Validate.notNull((Object)parentRole, (String)"\u672a\u627e\u5230\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272", (Object[])new Object[0]);
        }
    }

    @Transactional
    public void bindRoles(String userId, String[] roleNames) {
        Validate.notBlank((CharSequence)userId, (String)"\u7ed1\u5b9a\u6743\u9650\u65f6\uff0c\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserEntity user = this.userService.findDetailsById(userId);
        Validate.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((roleNames != null && roleNames.length > 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u8bf7\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272\u540d\u4fe1\u606f", (Object[])new Object[0]);
        HashSet<String> roleNameSet = new HashSet<String>();
        roleNameSet.addAll(Arrays.asList(roleNames));
        for (String roleName : roleNameSet) {
            RoleEntity currentRole = this.roleRepository.findByRoleName(roleName);
            Validate.notNull((Object)currentRole, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!!", (Object[])new Object[0]);
            try {
                this.roleRepository.bindUser(userId, currentRole.getId());
                this.roleRepository.flush();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u7ed1\u5b9a\u4fe1\u606f\uff0c\u8bf7\u68c0\u6d4b\u662f\u5426\u91cd\u590d\u7ed1\u5b9a\uff0c\u6216\u8005\u89d2\u8272\u4fe1\u606f\u672a\u4f20\u5165!");
            }
        }
    }

    @Transactional
    public void reBindRoles(String userId, String[] roleNames) {
        Validate.notBlank((CharSequence)userId, (String)"\u7ed1\u5b9a\u6743\u9650\u65f6\uff0c\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserEntity user = this.userService.findDetailsById(userId);
        Validate.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notEmpty((Object[])roleNames, (String)"\u7ed1\u5b9a\u6216\u8005\u89e3\u7ed1\u5fc5\u987b\u4fdd\u8bc1\u7528\u6237\u62e5\u6709\u81f3\u5c11\u4e00\u4e2a\u76f4\u63a5\u7ed1\u5b9a\u7684\u89d2\u8272!!", (Object[])new Object[0]);
        HashSet<String> roleNameSet = new HashSet<String>();
        roleNameSet.addAll(Arrays.asList(roleNames));
        this.roleRepository.deleteRoleByUserId(userId);
        for (String roleName : roleNameSet) {
            RoleEntity currentRole = this.roleRepository.findByRoleName(roleName);
            Validate.notNull((Object)currentRole, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!!", (Object[])new Object[0]);
            try {
                this.roleRepository.bindUser(userId, currentRole.getId());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u7ed1\u5b9a\u4fe1\u606f\uff0c\u8bf7\u68c0\u6d4b\u662f\u5426\u91cd\u590d\u7ed1\u5b9a\uff0c\u6216\u8005\u89d2\u8272\u4fe1\u606f\u672a\u4f20\u5165!");
            }
        }
    }

    public Set<RoleVo> findByUser(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Sets.newHashSet();
        }
        List<RoleEntity> roles = this.roleRepository.findByUserId(userId);
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(roleVos);
    }

    /*
     * WARNING - void declaration
     */
    public List<RoleVo> findAllByUserId(String userId, Integer type) {
        void var8_15;
        Set<OrganizationEntity> orgs;
        Set<UserGroupEntity> groups;
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Collections.emptyList();
        }
        HashSet<RoleEntity> resultRoles = new HashSet<RoleEntity>();
        List<RoleEntity> roles = this.roleRepository.findByUserId(userId);
        if (roles != null && !roles.isEmpty()) {
            this.setSource(Sets.newHashSet(roles), sourceMap, "user");
            resultRoles.addAll(roles);
        }
        if ((groups = this.userGroupRepository.findByUserId(userId)) != null && !groups.isEmpty()) {
            for (UserGroupEntity userGroupEntity : groups) {
                this.setSource(userGroupEntity.getRoles(), sourceMap, "group");
            }
            groups.stream().filter(item -> item.getRoles() != null && item.getTstatus() == 1).forEach(item -> resultRoles.addAll(item.getRoles()));
        }
        if ((orgs = this.organizationRepository.findByUserId(userId)) != null && !orgs.isEmpty()) {
            for (OrganizationEntity item3 : orgs) {
                this.setSource(item3.getRoles(), sourceMap, "org");
            }
            orgs.stream().filter(item -> item.getRoles() != null && item.getTstatus() == 1).forEach(item -> resultRoles.addAll(item.getRoles()));
        }
        HashSet hashSet = new HashSet();
        if (type != null && type.equals(1)) {
            List positions = this.positionService.findByUserId(userId);
            if (!CollectionUtils.isEmpty((Collection)positions)) {
                List<String> positionIds = positions.stream().map(PositionVo::getId).collect(Collectors.toList());
                Set<RoleEntity> set = this.roleRepository.findByPositions(positionIds);
            }
        } else {
            PositionVo positionVo = this.positionService.findMainPositionByUserId(userId);
            if (positionVo != null) {
                Set<RoleEntity> set = this.roleRepository.findByPosition(positionVo.getId());
            }
        }
        resultRoles.addAll((Collection<RoleEntity>)var8_15);
        this.setSource((Set<RoleEntity>)var8_15, sourceMap, "position");
        if (resultRoles.isEmpty()) {
            return Collections.emptyList();
        }
        List roleEntitys = resultRoles.stream().filter(item -> item.getTstatus() == 1).collect(Collectors.toList());
        ArrayList<RoleVo> roleVos = new ArrayList<RoleVo>();
        for (RoleEntity entity : roleEntitys) {
            RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(entity, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            String sourceName = (String)sourceMap.get(roleVo.getId());
            roleVo.setSource(sourceName);
            roleVo.setParent(this.findParentRole(entity));
            roleVos.add(roleVo);
        }
        return roleVos.stream().sorted(Comparator.comparing(RoleVo::getCreateDate)).collect(Collectors.toList());
    }

    private void setSource(Set<RoleEntity> roles, Map<String, String> sourceMap, String source) {
        if (CollectionUtils.isEmpty(roles)) {
            return;
        }
        for (RoleEntity roleEntity : roles) {
            if (sourceMap.containsKey(roleEntity.getId())) {
                String value = sourceMap.get(roleEntity.getId()) + "," + source;
                sourceMap.put(roleEntity.getId(), value);
                continue;
            }
            sourceMap.put(roleEntity.getId(), source);
        }
    }

    public List<RoleVo> findByCompetenceId(String competenceId) {
        if (StringUtils.isBlank((CharSequence)competenceId)) {
            return Lists.newArrayList();
        }
        List<RoleEntity> roles = this.roleRepository.findByCompetenceId(competenceId);
        if (roles == null || roles.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(roleVos);
    }

    public List<RoleVo> findByStatus(Integer useStatus) {
        if (useStatus == null) {
            return Collections.emptyList();
        }
        List<RoleEntity> rolesList = this.roleRepository.findByTstatus(useStatus);
        if (rolesList == null || rolesList.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(rolesList, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(roleVos);
    }

    public RoleVo findById(String roleId) {
        Validate.notNull((Object)roleId, (String)"role Id must not null!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        if (!op.isPresent()) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(op.get(), RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<RoleVo> findAll() {
        List rolesList = this.roleRepository.findAll(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createDate")}));
        if (rolesList == null || rolesList.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(rolesList, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(roleVos);
    }

    public Set<RoleVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<RoleEntity> roles = this.roleRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(roles)) {
            return Sets.newHashSet();
        }
        Collection<RoleVo> rvos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(rvos);
    }

    public Set<RoleVo> findRoleTree() {
        LinkedHashSet<RoleVo> roleSet = new LinkedHashSet<RoleVo>();
        Set<RoleEntity> rootRoles = this.roleRepository.findByParentIsNull();
        if (CollectionUtils.isEmpty(rootRoles)) {
            return Sets.newHashSet();
        }
        for (RoleEntity roleEntity : rootRoles) {
            RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(roleEntity, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            roleVo.setChildren(this.findChildrenRole(roleEntity));
            roleSet.add(roleVo);
        }
        return roleSet;
    }

    public Set<RoleVo> findChildrenRole(RoleEntity roleEntity) {
        LinkedHashSet<RoleVo> roleVoSet = new LinkedHashSet<RoleVo>();
        Set<RoleEntity> children = roleEntity.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return Sets.newHashSet();
        }
        for (RoleEntity child : children) {
            RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(child, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            roleVo.setChildren(this.findChildrenRole(child));
            roleVoSet.add(roleVo);
        }
        return roleVoSet;
    }

    private RoleVo findParentRole(RoleEntity child) {
        RoleEntity parent = child.getParent();
        if (parent == null) {
            return null;
        }
        if ((parent = (RoleEntity)this.roleRepository.findById(parent.getId()).orElse(null)) == null) {
            return null;
        }
        RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(parent, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        roleVo.setParent(this.findParentRole(parent));
        return roleVo;
    }

    public Set<RoleVo> findByRoleNameLike(String roleName) {
        Set<RoleEntity> roleSet = this.roleRepository.findByRoleNameLike(roleName);
        if (CollectionUtils.isEmpty(roleSet)) {
            return Sets.newHashSet();
        }
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(roleSet, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(roleVos);
    }

    public RoleVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        RoleEntity role = this.roleRepository.findByRoleCode(code);
        if (role == null) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(role, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void bindButtons(String roleId, String[] buttonIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u89d2\u8272\u548c\u6309\u94ae\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])buttonIds, (String)"\u8fdb\u884c\u89d2\u8272\u548c\u6309\u94ae\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String buttonId : buttonIds) {
            ButtonVo opButton = this.buttonService.findDateilsById(buttonId);
            Validate.notNull((Object)opButton, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonId});
            long count = this.roleRepository.countByRoleIdAndButtonId(roleId, buttonId);
            if (count != 0L) continue;
            this.roleRepository.bindButton(roleId, buttonId);
        }
    }

    @Transactional
    public void unbindButtons(String roleId, String[] buttonIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u89d2\u8272\u548c\u6309\u94ae\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])buttonIds, (String)"\u8fdb\u884c\u89d2\u8272\u548c\u6309\u94ae\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String buttonId : buttonIds) {
            ButtonVo opButton = this.buttonService.findDateilsById(buttonId);
            Validate.notNull((Object)opButton, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonId});
            this.roleRepository.unbindButton(roleId, buttonId);
        }
    }
}

