/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.model.ResponseCode;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.Format;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
public class BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Value(value="${nebula.http.enableCglibCopy:true}")
    private Boolean enableCglibCopy;

    protected String getPrincipalAccount() {
        Principal userPrincipal = this.getPrincipal();
        String account = userPrincipal.getName();
        Validate.notBlank((CharSequence)account, (String)"not found op user!", (Object[])new Object[0]);
        return account;
    }

    protected Principal getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7cfb\u7edf\u7684\u767b\u5f55\u4eba", (Object[])new Object[0]);
        return authentication;
    }

    protected ResponseModel buildHttpResultForException(Throwable e) {
        return new ResponseModel(new Date().getTime(), null, ResponseCode.E501, e);
    }

    protected ResponseModel buildHttpResult() {
        return new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
    }

    protected ResponseModel buildHttpResult(Object data) {
        return new ResponseModel(new Date().getTime(), data, ResponseCode.E0, null);
    }

    protected <T> ResponseModel buildHttpResultW(Page<T> page, String ... properties) {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
        if (page == null || CollectionUtils.isEmpty((Collection)page.getContent())) {
            result.setData(page);
            return result;
        }
        if (!this.enableCglibCopy.booleanValue()) {
            try {
                for (Object item : page) {
                    this.filterPropertyW(item, item.getClass(), new LinkedList<String>(), properties);
                }
                result.setData(page);
            }
            catch (Exception e) {
                result.setErrorMsg(e.getMessage());
                result.setMessage(e.getMessage());
                result.setResponseCode(ResponseCode.E501);
                result.setSuccess(false);
            }
            return result;
        }
        List contents = page.getContent();
        int size = contents.size();
        ArrayList<Object> targetContent = new ArrayList<Object>(size);
        try {
            for (int index = 0; index < size; ++index) {
                Object source = contents.get(index);
                Class<?> objectClass = source.getClass();
                Object target = null;
                target = !this.allowCopyObject(objectClass) ? (Object)source : (Object)this.nebulaToolkitService.copyObjectByWhiteList(source, source.getClass(), HashSet.class, ArrayList.class, properties);
                targetContent.add(target);
            }
            PageImpl targetPage = new PageImpl(targetContent, page.getPageable(), page.getTotalElements());
            result.setData(targetPage);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result.setErrorMsg(e.getMessage());
            result.setMessage(e.getMessage());
            result.setResponseCode(ResponseCode.E501);
            result.setSuccess(false);
        }
        return result;
    }

    protected <T> ResponseModel buildHttpResultW(Iterable<T> entities, String ... properties) {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
        if (entities == null) {
            return result;
        }
        Class<?> iterableClass = entities.getClass();
        if (JSON.class.isAssignableFrom(iterableClass)) {
            result.setData(entities);
            return result;
        }
        if (!this.enableCglibCopy.booleanValue()) {
            try {
                for (T item : entities) {
                    this.filterPropertyW(item, item.getClass(), new LinkedList<String>(), properties);
                }
                result.setData(entities);
            }
            catch (Exception e) {
                result.setErrorMsg(e.getMessage());
                result.setMessage(e.getMessage());
                result.setResponseCode(ResponseCode.E501);
                result.setSuccess(false);
            }
            return result;
        }
        LinkedList<Object> targetCollection = new LinkedList<Object>();
        try {
            for (T t : entities) {
                Class<?> tClass = t.getClass();
                if (!this.allowCopyObject(tClass)) {
                    targetCollection.add(t);
                    continue;
                }
                targetCollection.add(this.nebulaToolkitService.copyObjectByWhiteList(t, t.getClass(), HashSet.class, ArrayList.class, properties));
            }
            result.setData(targetCollection);
        }
        catch (Exception e) {
            result.setErrorMsg(e.getMessage());
            result.setMessage(e.getMessage());
            result.setResponseCode(ResponseCode.E501);
            result.setSuccess(false);
        }
        return result;
    }

    private boolean allowCopyObject(Class<?> objectClass) {
        if (objectClass.isPrimitive() || objectClass == Byte.class || objectClass == Short.class || objectClass == Integer.class || objectClass == Long.class || objectClass == Float.class || objectClass == Double.class || objectClass == Character.class || objectClass == Boolean.class) {
            return false;
        }
        if (CharSequence.class.isAssignableFrom(objectClass) || Date.class.isAssignableFrom(objectClass) || Temporal.class.isAssignableFrom(objectClass) || objectClass.isEnum() || JSON.class.isAssignableFrom(objectClass)) {
            return false;
        }
        String fieldTypeName = objectClass.getName();
        return !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.lang.") && !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.math.") && !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.io.") && !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.text.");
    }

    protected <T> ResponseModel buildHttpResultW(T object, String ... properties) {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
        if (object == null) {
            return result;
        }
        Class<?> objectClass = object.getClass();
        if (!this.enableCglibCopy.booleanValue()) {
            try {
                this.filterPropertyW(object, objectClass, new LinkedList<String>(), properties);
            }
            catch (Exception e) {
                result.setErrorMsg(e.getMessage());
                result.setMessage(e.getMessage());
                result.setResponseCode(ResponseCode.E501);
                result.setSuccess(false);
            }
            result.setData(object);
            return result;
        }
        if (!this.allowCopyObject(objectClass)) {
            result.setData(object);
            return result;
        }
        Object targetObject = null;
        try {
            targetObject = this.nebulaToolkitService.copyObjectByWhiteList(object, objectClass, HashSet.class, ArrayList.class, properties);
        }
        catch (Exception e) {
            result.setErrorMsg(e.getMessage());
            result.setMessage(e.getMessage());
            result.setResponseCode(ResponseCode.E501);
            result.setSuccess(false);
        }
        result.setData(targetObject);
        return result;
    }

    protected void writeResponseFile(HttpServletResponse response, int httpType, byte[] result) {
        if (httpType == 1) {
            response.setContentType("image/jpeg;charset=utf-8");
            response.setHeader("cache-control", "max-age=2628000");
            response.setContentLengthLong((long)result.length);
        } else if (httpType == 2) {
            response.setContentType("audio/mp3;charset=utf-8");
        } else if (httpType == 3) {
            response.setContentType("video/mpeg4;charset=utf-8");
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u6587\u4ef6\u7c7b\u578b");
        }
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(result);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected void writeResponseFile(HttpServletRequest request, HttpServletResponse response, byte[] result, String fileName) {
        String currentFileName;
        try {
            currentFileName = StringUtils.isBlank((CharSequence)fileName) ? "temp" : URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            currentFileName = "temp";
        }
        response.setContentType("application/octet-stream;charset=utf-8");
        response.addHeader("Content-Disposition", "attachment;fileName=" + this.encodeFileName(request, currentFileName));
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(result);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String encodeFileName(HttpServletRequest request, String fileName) {
        String agent = request.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)agent)) {
            try {
                return URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (agent.contains("Firefox") || agent.contains("Safari")) {
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        } else if (agent.contains("Chrome")) {
            try {
                fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return fileName;
    }

    protected void printResponseModel(ResponseModel responseModel, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(JSON.toJSONString((Object)responseModel).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void filterPropertyW(Object currentObject, Class<?> currentClass, LinkedList<String> parentProperties, String ... properties) throws IllegalAccessException, InvocationTargetException {
        if (parentProperties == null) {
            parentProperties = Lists.newLinkedList();
        }
        if (currentObject == null) {
            return;
        }
        Field[] fields = currentClass.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (superClass != null) {
            this.filterPropertyW(currentObject, superClass, parentProperties, properties);
        }
        for (Field fieldItem : fields) {
            String currentFieldName = fieldItem.getName();
            Method getMethod = null;
            Method setMethod = null;
            Class<?> fieldClass = fieldItem.getType();
            try {
                char[] chars = currentFieldName.toCharArray();
                chars[0] = (char)(chars[0] - 32);
                getMethod = currentClass.getMethod("get" + String.valueOf(chars), new Class[0]);
                chars = currentFieldName.toCharArray();
                chars[0] = (char)(chars[0] - 32);
                setMethod = currentClass.getMethod("set" + String.valueOf(chars), fieldClass);
            }
            catch (NoSuchMethodException | RuntimeException e) {
                LOGGER.debug(e.getMessage());
            }
            if (getMethod == null || setMethod == null) continue;
            String currentFieldNames = null;
            if (parentProperties != null && !parentProperties.isEmpty()) {
                Object[] fieldNames = parentProperties.toArray(new String[0]);
                currentFieldNames = StringUtils.join((Object[])new String[]{StringUtils.join((Object[])fieldNames, (String)"."), ".", currentFieldName});
            } else {
                currentFieldNames = currentFieldName;
            }
            if (this.baseForPropertyW(fieldItem)) continue;
            if (Collection.class.isAssignableFrom(fieldClass)) {
                if (properties == null || properties.length == 0 || !Arrays.asList(properties).contains(currentFieldNames)) {
                    setMethod.invoke(currentObject, new Object[]{null});
                    continue;
                }
                Object fieldValue = getMethod.invoke(currentObject, new Object[0]);
                if (fieldValue == null) continue;
                parentProperties.addLast(currentFieldName);
                Collection collections = (Collection)fieldValue;
                for (Object propertyObject : collections) {
                    Class<?> propertyClass = propertyObject.getClass();
                    this.filterPropertyW(propertyObject, propertyClass, parentProperties, properties);
                }
                parentProperties.removeLast();
                continue;
            }
            if (!this.baseForPropertyW(fieldItem) && Arrays.asList(properties).contains(currentFieldNames)) {
                if (properties == null || properties.length == 0) {
                    setMethod.invoke(currentObject, new Object[]{null});
                    continue;
                }
                Object currentFieldValue = getMethod.invoke(currentObject, new Object[0]);
                if (currentFieldValue == null) continue;
                parentProperties.addLast(currentFieldName);
                this.filterPropertyW(currentFieldValue, currentFieldValue.getClass(), parentProperties, properties);
                parentProperties.removeLast();
                continue;
            }
            setMethod.invoke(currentObject, new Object[]{null});
        }
    }

    private boolean baseForPropertyW(Field fieldItem) {
        Class<?> fieldItemClass = fieldItem.getType();
        if (fieldItemClass.isPrimitive() || fieldItemClass == Byte.TYPE || fieldItemClass == Short.TYPE || fieldItemClass == Integer.TYPE || fieldItemClass == Long.TYPE || fieldItemClass == Float.TYPE || fieldItemClass == Double.TYPE || fieldItemClass == Character.TYPE || fieldItemClass == Boolean.TYPE || fieldItemClass == Byte.class || fieldItemClass == Short.class || fieldItemClass == Integer.class || fieldItemClass == Long.class || fieldItemClass == Float.class || fieldItemClass == Double.class || fieldItemClass == Character.class || fieldItemClass == Boolean.class) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(fieldItemClass)) {
            return true;
        }
        return Date.class.isAssignableFrom(fieldItemClass) || Number.class.isAssignableFrom(fieldItemClass) || Format.class.isAssignableFrom(fieldItemClass) || Temporal.class.isAssignableFrom(fieldItemClass);
    }
}

