/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import com.bizunited.platform.core.service.EnvironmentVariableService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/environmentVariables"})
public class EnvironmentVariableController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentVariableController.class);
    @Autowired
    private EnvironmentVariableService environmentVariableService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u53c2\u6570")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            return this.buildHttpResultW(this.environmentVariableService.findAll(), new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u53c2\u6570")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@RequestParam(name="paramCode") @ApiParam(name="paramCode", value="paramCode") String paramCode, @RequestParam(name="paramKey") @ApiParam(name="paramKey", value="paramKey") String paramKey, @RequestParam(name="paramValue") @ApiParam(name="paramValue", value="paramValue") String paramValue, @RequestParam(name="paramType") @ApiParam(name="paramType", value="paramType") String paramType, @RequestParam(name="paramStatus") @ApiParam(name="paramStatus", value="paramStatus") Integer paramStatus, Pageable pageable) {
        try {
            return this.buildHttpResultW(this.environmentVariableService.findByConditions(paramCode, paramKey, paramValue, paramType, paramStatus, pageable), new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7f16\u53f7\u67e5\u8be2\u73af\u5883\u53d8\u91cf\u4fe1\u606f")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(name="code") @ApiParam(name="code", value="\u5168\u7cfb\u7edf\u552f\u4e00\u7684\u4e1a\u52a1\u7f16\u7801") String code) {
        try {
            return this.buildHttpResultW(this.environmentVariableService.findByCode(code), new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636ekey\u67e5\u8be2\u53c2\u6570")
    @RequestMapping(value={"/findByKey"}, method={RequestMethod.GET})
    public ResponseModel findByKey(@RequestParam(name="key") @ApiParam(name="key", value="key") String key) {
        try {
            return this.buildHttpResultW(this.environmentVariableService.findByKey(key), "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u53c2\u6570")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseModel save(@ApiParam(name="\u53c2\u6570") @RequestBody EnvironmentVariableEntity entity) {
        try {
            return this.buildHttpResultW(this.environmentVariableService.save(entity), "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u542f\u7528\u53c2\u6570")
    @RequestMapping(value={"/enable"}, method={RequestMethod.POST})
    public ResponseModel enable(@RequestParam(name="id") @ApiParam(name="id", value="ID") String id) {
        try {
            return this.buildHttpResultW(this.environmentVariableService.enable(id), "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528\u53c2\u6570")
    @RequestMapping(value={"/disable"}, method={RequestMethod.POST})
    public ResponseModel disable(@RequestParam(name="id") @ApiParam(name="id", value="ID") String id) {
        try {
            return this.buildHttpResultW(this.environmentVariableService.disable(id), "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u53c2\u6570")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseModel delete(@RequestParam(name="id") @ApiParam(name="id", value="ID") String id) {
        try {
            this.environmentVariableService.delete(id);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

