/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.RemoteServiceEntity;
import com.bizunited.platform.core.service.RemoteServiceService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/remoteServices"})
public class RemoteServiceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceController.class);
    @Autowired
    private RemoteServiceService remoteServiceService;

    @ApiOperation(value="\u6d4b\u8bd5\u4e00\u4e2a\u65b0\u7684\u8fdc\u7aef\u8c03\u7528\u6e90\u5730\u5740")
    @RequestMapping(value={"/valid"}, method={RequestMethod.POST})
    public ResponseModel valid(@ApiParam(name="entity", value="\u6307\u5b9a\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u57fa\u672c\u4fe1\u606f") @RequestParam(name="entity") String entity, @ApiParam(name="paramJson", value="\u6d4b\u8bd5\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u53c2\u6570\u7ed3\u6784") @RequestParam(name="paramJson") String paramJson) {
        try {
            JSON resultJSON = this.remoteServiceService.valid(entity, paramJson);
            return this.buildHttpResultW(resultJSON, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6267\u884c\u4e00\u4e2a\u8fdc\u7aef\u8c03\u7528\u670d\u52a1")
    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    public ResponseModel execute(@ApiParam(name="code", value="\u6307\u5b9a\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u4e1a\u52a1\u7f16\u53f7") @RequestParam(name="code") String code, @ApiParam(name="paramJson", value="\u6267\u884c\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u53c2\u6570\u7ed3\u6784") @RequestParam(name="paramJson") String paramJson) {
        try {
            JSON resultJSON = this.remoteServiceService.execute(code, paramJson);
            return this.buildHttpResultW(resultJSON, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u8fdc\u7aef\u8c03\u7528\u6e90\u5730\u5740")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="entity", value="\u6307\u5b9a\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u57fa\u672c\u4fe1\u606f") @RequestParam(name="entity") String entity, @ApiParam(name="paramJson", value="\u65b0\u589e\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u53c2\u6570\u7ed3\u6784") @RequestParam(name="paramJson") String paramJson) {
        try {
            RemoteServiceEntity remoteServiceAddressEntity = this.remoteServiceService.create(entity, paramJson);
            return this.buildHttpResultW(remoteServiceAddressEntity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u4e00\u4e2a\u65b0\u7684\u8fdc\u7aef\u8c03\u7528\u6e90\u5730\u5740")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseModel update(@ApiParam(name="entity", value="\u6307\u5b9a\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u57fa\u672c\u4fe1\u606f") @RequestParam(name="entity") String entity, @ApiParam(name="paramJson", value="\u66f4\u65b0\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u53c2\u6570\u7ed3\u6784") @RequestParam(name="paramJson") String paramJson) {
        try {
            RemoteServiceEntity remoteServiceAddressEntity = this.remoteServiceService.update(entity, paramJson);
            return this.buildHttpResultW(remoteServiceAddressEntity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528\u7528\u8fdc\u7aef\u8c03\u7528\u670d\u52a1")
    @RequestMapping(value={"/disable"}, method={RequestMethod.POST})
    public ResponseModel disable(@RequestParam(name="id") @ApiParam(value="id") String id) {
        try {
            RemoteServiceEntity entity = this.remoteServiceService.disable(id);
            return this.buildHttpResultW(entity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/enable"})
    @ApiOperation(value="\u542f\u7528\u7528\u8fdc\u7aef\u8c03\u7528\u670d\u52a1")
    public ResponseModel enable(@RequestParam(name="id") @ApiParam(value="id") String id) {
        try {
            RemoteServiceEntity entity = this.remoteServiceService.enable(id);
            return this.buildHttpResultW(entity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u6a21\u677f\uff1a\u7531\u7528\u6237\u624b\u52a8\u8f93\u5165\u4e00\u6bb5json\uff0c\u5e76\u8ba9\u5176\u4f5c\u4e3ahttp\u63a5\u53e3\u7684json\u6620\u5c04\u7ed3\u6784\uff0c\u8fdb\u884c\u5bfc\u5165")
    @RequestMapping(value={"/importJson"}, method={RequestMethod.POST})
    public ResponseModel importJson(@RequestParam(name="jsonStr") @ApiParam(value="jsonStr") String jsonStr) {
        try {
            JSONArray jsonArray = this.remoteServiceService.importJson(jsonStr);
            return this.buildHttpResultW(jsonArray, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\uff0c\u6839\u636e\u7f16\u53f7\uff0c\u522b\u540d")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@RequestParam(value="remoteServiceType", required=false) @ApiParam(value="remoteServiceType") Integer remoteServiceType, @RequestParam(value="addressCode", required=false) @ApiParam(value="addressCode") String addressCode, @RequestParam(value="addressAlias", required=false) @ApiParam(value="addressAlias") String addressAlias, @RequestParam(value="requestMethod", required=false) @ApiParam(value="requestMethod") String requestMethod, @RequestParam(value="remoteServiceStatus", required=false) @ApiParam(value="remoteServiceStatus") Integer remoteServiceStatus, Pageable pageable) {
        try {
            Page<RemoteServiceEntity> page = this.remoteServiceService.findByConditions(remoteServiceType, addressCode, addressAlias, requestMethod, remoteServiceStatus, pageable);
            return this.buildHttpResultW(page, new String[]{"remoteServiceAddress"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u8349\u7a3f\uff0c\u6309\u7167\u4e1a\u52a1\u7f16\u53f7\u3002\u6ce8\u610f\u8fd9\u4e2ajson\u4e2d\u7684\u4fe1\u606f\u4e0d\u56de\u5305\u62echead\u3001\u8bf7\u6c42\u53c2\u6570\u8bbe\u5b9a\u7b49\u4fe1\u606f")
    @RequestMapping(value={"/findJsonByCode"}, method={RequestMethod.GET})
    public ResponseModel findJsonByCode(@RequestParam(name="code") @ApiParam(name="code", value="\u7cfb\u7edf\u552f\u4e00\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") String code) {
        try {
            String json = this.remoteServiceService.findJsonByCode(code);
            return this.buildHttpResultW(json, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7f16\u53f7\u67e5\u8be2\u4fdd\u5b58\u5728\u6587\u4ef6\u4e2d\u7684\u683c\u5f0fJSON\uff0c\u6ce8\u610f\u8fd9\u4e2ajson\u4fe1\u606f\u662f\u5305\u62echead\u4fe1\u606f\u3001\u8bf7\u6c42\u53c2\u6570\u8bbe\u5b9a\u7b49\u7684\u5b8c\u6574\u4fe1\u606f")
    @RequestMapping(value={"/findCompleteByCode"}, method={RequestMethod.GET})
    public ResponseModel findCompleteByCode(@RequestParam(name="code") @ApiParam(name="code", value="\u7cfb\u7edf\u552f\u4e00\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") String code) {
        try {
            JSON json = this.remoteServiceService.findCompleteByCode(code);
            return this.buildHttpResultW(json, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

