/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.internal.UserRepositoryCustom;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="UserRepository")
public interface UserRepository
extends JpaRepository<UserEntity, String>,
JpaSpecificationExecutor<UserEntity>,
UserRepositoryCustom {
    @Modifying
    @Query(value="update engine_user set lastlogin_time = :lastloginTime where user_account = :account ", nativeQuery=true)
    public void updateLastloginTime(@Param(value="account") String var1, @Param(value="lastloginTime") Date var2);

    @Query(value="from UserEntity u where u.account = :account")
    public UserEntity findByAccount(@Param(value="account") String var1);

    @Query(value="select distinct m from UserEntity m  left join fetch m.orgs  left join fetch m.groups  left join fetch m.positions where m.account = :account")
    public UserEntity findDetailsByAccount(@Param(value="account") String var1);

    @Query(value="from UserEntity  u where u.account like CONCAT(CONCAT('%',:account),'%')")
    public List<UserEntity> findByAccountLike(@Param(value="account") String var1);

    @Query(value="from UserEntity  u where u.userName like CONCAT(CONCAT('%',:username),'%')")
    public List<UserEntity> findByUserNameLike(@Param(value="username") String var1);

    @Query(value="select distinct m from UserEntity m  left join fetch m.orgs  left join fetch m.groups  left join fetch m.positions where m.id = :id ")
    public UserEntity findDetailsById(@Param(value="id") String var1);

    public UserEntity findByPhone(String var1);

    @Query(value="from UserEntity m where m.id in :ids")
    public Set<UserEntity> findByIds(@Param(value="ids") List<String> var1);

    @Query(value="select u from UserEntity u inner join u.orgs o inner join u.roles r where o.code = :orgCode and r.roleCode = :roleCode")
    public Set<UserEntity> findByOrgCodeAndRoleCode(@Param(value="orgCode") String var1, @Param(value="roleCode") String var2);

    @Query(value="select u from UserEntity u left join fetch u.orgs o where o.id = :orgId ")
    public List<UserEntity> findByOrgId(@Param(value="orgId") String var1);
}

