/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.repository.dataview.analysis.Constants;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class SQLAuthVerticalAnalysis {
    private SQLAuthVerticalAnalysis() {
    }

    public static void buildSQLAuthVertical(Set<DataViewAuthVerticalEntity> auths, String sql, Map<SQLCorrelationEnum, Object> map, Set<DataViewFieldEntity> allFileds) {
        if (map == null) {
            map = new HashMap<SQLCorrelationEnum, Object>();
        }
        if (CollectionUtils.isEmpty(auths)) {
            map.put(SQLCorrelationEnum.RESULT_SQL, String.format("select %s from (%s) %s where 1=1 ", "*", sql, "s01y01s01"));
            return;
        }
        HashSet<String> finalFieldNames = new HashSet<String>();
        Map presets = (Map)map.get((Object)SQLCorrelationEnum.VERTICAL_PRESETS);
        HashMap<Integer, HashSet<String>> verticalDispalyFields = new HashMap<Integer, HashSet<String>>();
        for (int i = 1; i <= Constants.AUTH_TYPE_COUNT; ++i) {
            Integer authType = i;
            Set<DataViewAuthVerticalEntity> sameAuths = auths.stream().filter(e -> authType.compareTo(e.getAuthType()) == 0).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(sameAuths)) continue;
            Set<String> fieldNames = SQLAuthVerticalAnalysis.buildFields(sameAuths, presets, i);
            verticalDispalyFields.put(i, finalFieldNames);
            finalFieldNames.addAll(fieldNames);
        }
        map.put(SQLCorrelationEnum.DISPLAY_FIELDS, finalFieldNames);
        Validate.notEmpty(finalFieldNames, (String)"\u6c92\u6709\u5bf9\u5e94\u6743\u9650\uff08\u67e5\u8be2\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5sql\u6216\u7eb5\u5411\u6743\u9650\u914d\u7f6e\uff09", (Object[])new Object[0]);
        String verticalFields = String.join((CharSequence)",", finalFieldNames);
        map.put(SQLCorrelationEnum.RESULT_SQL, String.format("select %s from (%s) %s where 1=1 ", verticalFields, sql, "s01y01s01"));
    }

    public static Set<String> buildFields(Set<DataViewAuthVerticalEntity> auths, Map<Integer, Object> presets) {
        HashSet<String> fieldNames = new HashSet<String>();
        if (CollectionUtils.isEmpty(auths)) {
            return fieldNames;
        }
        for (int i = 1; i <= Constants.AUTH_TYPE_COUNT; ++i) {
            Integer authType = i;
            Set<DataViewAuthVerticalEntity> sameAuths = auths.stream().filter(e -> authType.compareTo(e.getAuthType()) == 0).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(sameAuths)) continue;
            Set<String> fields = SQLAuthVerticalAnalysis.buildFields(sameAuths, presets, i);
            fieldNames.addAll(fields);
        }
        return fieldNames;
    }

    private static Set<String> buildFields(Set<DataViewAuthVerticalEntity> sameAuths, Map<Integer, Object> presets, Integer index) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (DataViewAuthVerticalEntity e : sameAuths) {
            Set<DataViewFieldEntity> displayFields = e.getDisplayFields();
            Validate.notEmpty(displayFields, (String)"\u7eb5\u5411\u6743\u9650\u4e2d\u6ca1\u6709\u6307\u5b9a\u663e\u793a\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Set<DataViewAuthVerticalRelationEntity> relations = e.getAuthRelations();
            if (CollectionUtils.isEmpty(relations)) continue;
            Object o = presets.get(index);
            boolean result = SQLAuthVerticalAnalysis.validateAuth(relations, e.getOprtType(), index, o);
            if (!result) continue;
            fieldNames.addAll(displayFields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet()));
        }
        return fieldNames;
    }

    public static boolean validateAuth(Set<DataViewAuthVerticalRelationEntity> relations, String oprtType, Integer relaType, Object o) {
        if (o == null) {
            if ("EQ".equals(oprtType) || "IN".equals(oprtType)) {
                return false;
            }
            if ("NEQ".equals(oprtType) || "NIN".equals(oprtType)) {
                return true;
            }
        }
        Set<Object> result = new HashSet();
        String relationType = String.valueOf(relaType);
        if (SQLCorrelationEnum.USER_RELATION.getCode().equals(relationType)) {
            UserVo user = (UserVo)o;
            HashSet<String> userAccount = new HashSet<String>();
            userAccount.add(user.getAccount());
            result = userAccount;
        }
        if (SQLCorrelationEnum.ROLE_RELATION.getCode().equals(relationType)) {
            List roles = (List)o;
            result = roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toSet());
        }
        if (SQLCorrelationEnum.POSITION_RELATION.getCode().equals(relationType)) {
            List positions = (List)o;
            result = positions.stream().map(PositionVo::getCode).collect(Collectors.toSet());
        }
        if (SQLCorrelationEnum.USER_GROUP_RELATION.getCode().equals(relationType)) {
            HashSet userGroups = (HashSet)o;
            result = userGroups.stream().map(UserGroupVo::getGroupName).collect(Collectors.toSet());
        }
        if (SQLCorrelationEnum.ORGS_RELATION.getCode().equals(relationType)) {
            HashSet orgs = (HashSet)o;
            result = orgs.stream().map(OrganizationVo::getCode).collect(Collectors.toSet());
        }
        Set relationStrs = relations.stream().map(DataViewAuthVerticalRelationEntity::getAuthRelationIds).collect(Collectors.toSet());
        Sets.SetView intersectionSets = Sets.intersection(result, relationStrs);
        Boolean flag = CollectionUtils.isEmpty((Collection)intersectionSets);
        if (("EQ".equals(oprtType) || "IN".equals(oprtType)) && !flag.booleanValue()) {
            return true;
        }
        return ("NEQ".equals(oprtType) || "NIN".equals(oprtType)) && flag != false;
    }
}

