/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRelationRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalRelationService;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthHorizontalRelationServiceImpl")
public class DataViewAuthHorizontalRelationServiceImpl
implements DataViewAuthHorizontalRelationService {
    @Autowired
    private DataViewAuthHorizontalRelationRepository dataViewAuthHorizontalRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity, Set<DataViewAuthHorizontalRelationEntity> authRelations) {
        Validate.notNull((Object)dataViewAuthHorizontalEntity, (String)"\u6a2a\u5411\u6570\u636e\u6743\u9650\u7684\u5bf9\u8c61\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(authRelations)) {
            return;
        }
        authRelations.forEach(x -> {
            x.setAuthHorizontal(dataViewAuthHorizontalEntity);
            this.createValidation((DataViewAuthHorizontalRelationEntity)x);
        });
        this.dataViewAuthHorizontalRelationRepository.saveAll(authRelations);
    }

    @Override
    public void createValidation(DataViewAuthHorizontalRelationEntity dataViewAuthHorizontalRelationEntity) {
        Validate.notNull((Object)dataViewAuthHorizontalRelationEntity, (String)"\u6743\u9650\u9886\u57df\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewAuthHorizontalRelationEntity.getId()), (String)"\u6dfb\u52a0\u6743\u9650\u9886\u57df\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewAuthHorizontalRelationEntity.setId(null);
        Validate.notNull((Object)dataViewAuthHorizontalRelationEntity.getAuthHorizontal(), (String)"\u6a2a\u5411\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalRelationEntity.getAuthRelationIds(), (String)"\u6743\u9650\u9886\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalRelationEntity.getSortIndex(), (String)"\u6743\u9650\u9886\u57df\u7684\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalRelationEntity.getAuthRelationIds() == null || dataViewAuthHorizontalRelationEntity.getAuthRelationIds().length() <= 255 ? 1 : 0) != 0, (String)"\u6743\u9650\u5173\u7cfb\u96c6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public void updateValidation(DataViewAuthHorizontalRelationEntity dataViewAuthHorizontalRelationEntity) {
        Validate.notNull((Object)dataViewAuthHorizontalRelationEntity, (String)"\u6743\u9650\u9886\u57df\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dataViewAuthHorizontalRelationEntity.getId()), (String)"\u4fee\u6539\u6743\u9650\u9886\u57df\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        DataViewAuthHorizontalEntity authHorizontal = dataViewAuthHorizontalRelationEntity.getAuthHorizontal();
        Validate.notNull((Object)authHorizontal, (String)"\u4f20\u5165\u7684\u6a2a\u5411\u6743\u9650\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalRelationEntity.getAuthRelationIds(), (String)"\u6743\u9650\u9886\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalRelationEntity.getSortIndex(), (String)"\u6743\u9650\u9886\u57df\u7684\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalRelationEntity.getAuthRelationIds() == null || dataViewAuthHorizontalRelationEntity.getAuthRelationIds().length() <= 255 ? 1 : 0) != 0, (String)"\u6743\u9650\u5173\u7cfb\u96c6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<DataViewAuthHorizontalRelationEntity> findDetailsByAuthHorizontal(String authHorizontal) {
        if (StringUtils.isBlank((CharSequence)authHorizontal)) {
            return Sets.newHashSet();
        }
        return this.dataViewAuthHorizontalRelationRepository.findDetailsByAuthHorizontal(authHorizontal);
    }

    @Override
    public DataViewAuthHorizontalRelationEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthHorizontalRelationRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthHorizontalRelationEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewAuthHorizontalRelationRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewAuthHorizontalRelationRepository.findById(id);
        op.ifPresent(dataViewAuthHorizontalRelationEntity -> this.dataViewAuthHorizontalRelationRepository.delete(dataViewAuthHorizontalRelationEntity));
    }

    @Override
    @Transactional
    public void deleteByAuthHorizontal(String authHorizontal) {
        Validate.notBlank((CharSequence)authHorizontal, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f!", (Object[])new Object[0]);
        this.dataViewAuthHorizontalRelationRepository.deleteByAuthHorizontal(authHorizontal);
    }

    @Override
    @Transactional
    public void save(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity, Set<DataViewAuthHorizontalRelationEntity> authRelations) {
        Set<DataViewAuthHorizontalRelationEntity> needInsertAuthRelations = null;
        Set<DataViewAuthHorizontalRelationEntity> needUpdateAuthRelations = null;
        if (!CollectionUtils.isEmpty(authRelations)) {
            needInsertAuthRelations = authRelations.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getId())).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty(authRelations)) {
            needUpdateAuthRelations = authRelations.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getId())).collect(Collectors.toSet());
        }
        Set<DataViewAuthHorizontalRelationEntity> dbAuthHorizoncalRelations = this.findDetailsByAuthHorizontal(dataViewAuthHorizontalEntity.getId());
        Set<String> needDeleteAuthHorizoncalRelationKeys = this.nebulaToolkitService.collectionDiffent(dbAuthHorizoncalRelations, authRelations, UuidEntity::getId);
        this.create(dataViewAuthHorizontalEntity, needInsertAuthRelations);
        if (!CollectionUtils.isEmpty(needUpdateAuthRelations)) {
            needUpdateAuthRelations.forEach(y -> {
                y.setAuthHorizontal(dataViewAuthHorizontalEntity);
                this.updateValidation((DataViewAuthHorizontalRelationEntity)y);
            });
            this.dataViewAuthHorizontalRelationRepository.saveAll(needUpdateAuthRelations);
        }
        if (!CollectionUtils.isEmpty(needDeleteAuthHorizoncalRelationKeys)) {
            needDeleteAuthHorizoncalRelationKeys.forEach(x -> this.dataViewAuthHorizontalRelationRepository.deleteById(x));
        }
    }
}

