/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthInterceptorRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthInterceptorService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DataViewAuthInterceptorServiceImpl")
public class DataViewAuthInterceptorServiceImpl
implements DataViewAuthInterceptorService {
    @Autowired
    private DataViewAuthInterceptorRepository dataViewAuthInterceptorRepository;
    @Autowired
    private DataViewService dataViewService;

    @Override
    @Transactional
    public DataViewAuthInterceptorEntity create(DataViewAuthInterceptorEntity interceptor) {
        this.createValidation(interceptor);
        return (DataViewAuthInterceptorEntity)this.dataViewAuthInterceptorRepository.save(interceptor);
    }

    @Override
    @Transactional
    public DataViewAuthInterceptorEntity update(DataViewAuthInterceptorEntity interceptor) {
        this.updateValidation(interceptor);
        DataViewAuthInterceptorEntity interceptorEntity = this.dataViewAuthInterceptorRepository.findById(interceptor.getId()).orElse(null);
        Validate.notNull((Object)interceptorEntity, (String)"\u62e6\u622a\u5668\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        interceptorEntity.setClassType(interceptor.getClassType());
        interceptorEntity.setInterceptor(interceptor.getInterceptor());
        return (DataViewAuthInterceptorEntity)this.dataViewAuthInterceptorRepository.save(interceptorEntity);
    }

    @Override
    public DataViewAuthInterceptorEntity findByDataView(String dataViewCode) {
        if (StringUtils.isBlank((CharSequence)dataViewCode)) {
            return null;
        }
        return this.dataViewAuthInterceptorRepository.findByDataViewCode(dataViewCode);
    }

    private void createValidation(DataViewAuthInterceptorEntity interceptor) {
        Validate.notNull((Object)interceptor, (String)"\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((interceptor.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u5bf9\u8c61ID\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)interceptor.getInterceptor(), (String)"\u62e6\u622a\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)interceptor.getClassType(), (String)"\u62e6\u622a\u5668\u7c7b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)interceptor.getDataView(), (String)"\u6570\u636e\u89c6\u56fe\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)interceptor.getDataView().getId(), (String)"\u6570\u636e\u89c6\u56fe\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewEntity dataView = this.dataViewService.findById(interceptor.getDataView().getId());
        Validate.notNull((Object)dataView, (String)"\u672a\u627e\u5230\u6570\u636e\u89c6\u56fe\u5bf9\u8c61", (Object[])new Object[0]);
        DataViewAuthInterceptorEntity oldInterceptor = this.dataViewAuthInterceptorRepository.findByDataView(dataView.getId());
        Validate.isTrue((oldInterceptor == null ? 1 : 0) != 0, (String)"\u8be5\u6570\u636e\u89c6\u56fe\u6743\u9650\u5df2\u5b58\u5728\u62e6\u622a\u5668\uff0c\u8bf7\u66f4\u65b0", (Object[])new Object[0]);
    }

    private void updateValidation(DataViewAuthInterceptorEntity interceptor) {
        Validate.notNull((Object)interceptor, (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)interceptor.getId(), (String)"\u66f4\u65b0\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)interceptor.getClassType(), (String)"\u62e6\u622a\u5668\u7c7b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)interceptor.getInterceptor(), (String)"\u62e6\u622a\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
    }
}

