/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.repository.dataview.DataViewFieldRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import com.bizunited.platform.core.service.dataview.DataViewFilterService;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DataViewFieldEntityServiceImpl")
public class DataViewFieldServiceImpl
implements DataViewFieldService {
    @Autowired
    private DataViewFieldRepository dataViewFieldEntityRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DataViewFilterService dataViewFilterService;
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;

    @Override
    public void createValidation(DataViewFieldEntity dataViewFieldEntity) {
        Validate.notNull((Object)dataViewFieldEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewFieldEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewFieldEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewFieldEntity.getFieldName(), (String)"\u5b57\u6bb5\u540d\uff08\u82f1\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFieldEntity.getFieldType(), (String)"\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFieldEntity.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFieldEntity.getPhysical(), (String)"\u662f\u5426\u7269\u7406\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFieldEntity.getTstatus(), (String)"\u662f\u5426\u6709\u6548\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFieldEntity.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getFieldName() == null || dataViewFieldEntity.getFieldName().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d\uff08\u82f1\u6587\uff09,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getFieldType() == null || dataViewFieldEntity.getFieldType().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getSchemaName() == null || dataViewFieldEntity.getSchemaName().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u5206\u5e93,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getTargetTable() == null || dataViewFieldEntity.getTargetTable().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u7406\u6570\u636e\u8868,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getTargetField() == null || dataViewFieldEntity.getTargetField().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u7406\u5b57\u6bb5,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataViewFieldEntity create(DataViewFieldEntity dataViewFieldEntity, boolean ignoreValidate) {
        if (!ignoreValidate) {
            this.createValidation(dataViewFieldEntity);
        }
        dataViewFieldEntity.setCode(UUID.randomUUID().toString());
        this.dataViewFieldEntityRepository.save(dataViewFieldEntity);
        return dataViewFieldEntity;
    }

    @Override
    @Transactional
    public DataViewFieldEntity update(DataViewFieldEntity dataViewFieldEntity) {
        this.updateValidation(dataViewFieldEntity);
        String currentId = dataViewFieldEntity.getId();
        Optional op = this.dataViewFieldEntityRepository.findById(currentId);
        DataViewFieldEntity currentDataViewFieldEntity = op.orElse(null);
        Validate.notNull((Object)currentDataViewFieldEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        currentDataViewFieldEntity.setFieldName(dataViewFieldEntity.getFieldName());
        currentDataViewFieldEntity.setFieldType(dataViewFieldEntity.getFieldType());
        currentDataViewFieldEntity.setSortIndex(dataViewFieldEntity.getSortIndex());
        currentDataViewFieldEntity.setPhysical(dataViewFieldEntity.getPhysical());
        currentDataViewFieldEntity.setSchemaName(dataViewFieldEntity.getSchemaName());
        currentDataViewFieldEntity.setTargetTable(dataViewFieldEntity.getTargetTable());
        currentDataViewFieldEntity.setTargetField(dataViewFieldEntity.getTargetField());
        currentDataViewFieldEntity.setTstatus(dataViewFieldEntity.getTstatus());
        currentDataViewFieldEntity.setDisplayName(dataViewFieldEntity.getDisplayName());
        currentDataViewFieldEntity.setEnumsource(dataViewFieldEntity.getEnumsource());
        currentDataViewFieldEntity.setAuthType(dataViewFieldEntity.getAuthType());
        this.dataViewFieldEntityRepository.save(currentDataViewFieldEntity);
        return currentDataViewFieldEntity;
    }

    @Override
    public void updateValidation(DataViewFieldEntity dataViewFieldEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewFieldEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFieldEntity.getFieldName(), (String)"\u5b57\u6bb5\u540d\uff08\u82f1\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFieldEntity.getFieldType(), (String)"\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFieldEntity.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFieldEntity.getPhysical(), (String)"\u662f\u5426\u7269\u7406\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFieldEntity.getTargetField(), (String)"\u7269\u7406\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFieldEntity.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFieldEntity.getTstatus(), (String)"\u662f\u5426\u6709\u6548\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getFieldName() == null || dataViewFieldEntity.getFieldName().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d\uff08\u82f1\u6587\uff09,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getDisplayName() == null || dataViewFieldEntity.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u663e\u793a\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getFieldType() == null || dataViewFieldEntity.getFieldType().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getSchemaName() == null || dataViewFieldEntity.getSchemaName().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u5206\u5e93,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getTargetTable() == null || dataViewFieldEntity.getTargetTable().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u7406\u6570\u636e\u8868,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFieldEntity.getTargetField() == null || dataViewFieldEntity.getTargetField().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u7406\u5b57\u6bb5,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<DataViewFieldEntity> findByDataView(String dataViewId) {
        if (StringUtils.isBlank((CharSequence)dataViewId)) {
            return Lists.newArrayList();
        }
        return this.dataViewFieldEntityRepository.findByDataView(dataViewId);
    }

    @Override
    public Set<DataViewFieldEntity> findAuthTypeFieldsByDataView(String dataViewId) {
        if (StringUtils.isBlank((CharSequence)dataViewId)) {
            return Collections.emptySet();
        }
        List<DataViewFieldEntity> dbFields = this.dataViewFieldEntityRepository.findByDataView(dataViewId);
        return dbFields.stream().filter(e -> e.getAuthType() != null).collect(Collectors.toSet());
    }

    @Override
    public DataViewFieldEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewFieldEntityRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewFieldEntityRepository.findById(id);
        op.ifPresent(dataViewFieldEntity -> this.dataViewFieldEntityRepository.deleteById(id));
    }

    @Override
    public DataViewFieldEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataViewFieldEntityRepository.findByCode(code);
    }

    @Override
    @Transactional
    public void create(Set<DataViewFieldEntity> fields, DataViewEntity dataViewEntity) {
        Validate.notEmpty(fields, (String)"\u89c6\u56fe\u7ed3\u6784\u7684\u8f93\u51fa\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        fields.forEach(e -> {
            this.createValidation((DataViewFieldEntity)e);
            e.setCode(UUID.randomUUID().toString());
            e.setDataView(dataViewEntity);
        });
        this.dataViewFieldEntityRepository.saveAll(fields);
    }

    @Override
    @Transactional
    public Set<DataViewFieldEntity> update(DataViewEntity dataView, Set<DataViewFieldEntity> fields) {
        Validate.notNull((Object)dataView, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getId(), (String)"\u6570\u636e\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        this.updateValidation(fields);
        Map<String, DataViewFieldEntity> fieldsMap = fields.stream().collect(Collectors.toMap(DataViewFieldEntity::getFieldName, v -> v));
        List<DataViewFieldEntity> oldFields = this.dataViewFieldEntityRepository.findByDataView(dataView.getId());
        HashSet<DataViewFieldEntity> createFields = new HashSet<DataViewFieldEntity>();
        HashSet updateFields = new HashSet();
        HashSet deleteFields = new HashSet();
        this.nebulaToolkitService.collectionDiscrepancy(fields, oldFields, DataViewFieldEntity::getFieldName, deleteFields, updateFields, createFields);
        for (DataViewFieldEntity field : createFields) {
            field.setDataView(dataView);
            field.setCode(UUID.randomUUID().toString());
            this.dataViewFieldEntityRepository.save(field);
        }
        for (DataViewFieldEntity field : updateFields) {
            DataViewFieldEntity newField = fieldsMap.get(field.getFieldName());
            field.setDisplayName(newField.getDisplayName());
            field.setFieldType(newField.getFieldType());
            field.setPhysical(newField.getPhysical());
            field.setTargetField(newField.getTargetField());
            field.setTargetTable(newField.getTargetTable());
            field.setTstatus(newField.getTstatus());
            field.setEnumsource(newField.getEnumsource());
            this.dataViewFieldEntityRepository.save(field);
        }
        for (DataViewFieldEntity field : deleteFields) {
            this.dataViewFilterService.deleteByField(field.getId());
            this.dataViewAuthHorizontalService.deleteByField(field.getId());
            this.dataViewAuthVerticalService.deleteByField(field.getId());
            this.dataViewFieldEntityRepository.delete(field);
        }
        createFields.addAll(updateFields);
        return createFields;
    }

    private void updateValidation(Set<DataViewFieldEntity> fields) {
        Validate.notEmpty(fields, (String)"\u6570\u636e\u89c6\u56fe\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (DataViewFieldEntity field : fields) {
            Validate.notBlank((CharSequence)field.getFieldName(), (String)"\u5b57\u6bb5\u540d\uff08\u82f1\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)field.getFieldType(), (String)"\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)field.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)field.getPhysical(), (String)"\u662f\u5426\u7269\u7406\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)field.getTargetField(), (String)"\u7269\u7406\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)field.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)field.getTstatus(), (String)"\u662f\u5426\u6709\u6548\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((field.getFieldName() == null || field.getFieldName().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d\uff08\u82f1\u6587\uff09,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((field.getDisplayName() == null || field.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u663e\u793a\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((field.getFieldType() == null || field.getFieldType().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((field.getSchemaName() == null || field.getSchemaName().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u5206\u5e93,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((field.getTargetTable() == null || field.getTargetTable().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u7406\u6570\u636e\u8868,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((field.getTargetField() == null || field.getTargetField().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u7406\u5b57\u6bb5,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
    }
}

