/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.util;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.security.Principal;
import org.apache.commons.lang3.Validate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public final class SecurityUtils {
    private SecurityUtils() {
        throw new IllegalStateException("\u9759\u6001\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316");
    }

    public static Principal getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7cfb\u7edf\u7684\u767b\u5f55\u4eba", (Object[])new Object[0]);
        return authentication;
    }

    public static String getUserAccount() {
        Principal principal = SecurityUtils.getPrincipal();
        String account = principal.getName();
        Validate.notBlank((CharSequence)"\u672a\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7684\u767b\u5f55\u8d26\u53f7");
        return account;
    }

    public static UserVo getCurrentUser() {
        String account = SecurityUtils.getUserAccount();
        UserService userService = (UserService)PlatformContext.getApplicationContext().getBean(UserService.class);
        UserVo userVo = userService.findByAccount(account);
        Validate.notNull((Object)userVo, (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff1a%s", (Object[])new Object[]{account});
        return userVo;
    }
}

