package com.bizunited.platform.core.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Import;

import com.bizunited.platform.core.configuration.PlatformCoreConfig;

/**
 * 如果您的业务系统只需要启动技术中台的核心工具包，而不需要开启技术中台包括表单引擎、流程引擎、规则引擎、服务调度、用户中心
 * 在内的任何组件，则可以使用该注解仅仅开启基础工具包的支撑
 * @author yinwenjie
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.TYPE })
@Documented
@Import(PlatformCoreConfig.class)
public @interface EnablePlatformCore {

}