package com.bizunited.platform.core.common.constant;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

/**
 * 非业务表配置
 *
 * @Author: Paul Chan
 * @Date: 2019-04-17 09:30
 */
@SuppressWarnings("unchecked")
public class UnBusinessTableConst {

  private static final  Logger LOGGER = LoggerFactory.getLogger(UnBusinessTableConst.class);

  private static final Set<String> UN_BUSINESS_TABLE = new HashSet<>();

  static {
    try (InputStream is = UnBusinessTableConst.class.getClassLoader().getResourceAsStream("unbusiness-table.json");
         BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is))) {
      StringBuilder sb = new StringBuilder();
      String line = bufferedReader.readLine();
      while (StringUtils.isNotBlank(line)){
        sb.append(line);
        line = bufferedReader.readLine();
      }
      Set<String> tables = JSON.parseObject(sb.toString(), HashSet.class);
      UN_BUSINESS_TABLE.addAll(tables);
    } catch (IOException e) {
      LOGGER.error(e.getMessage(), e);
    }
  }
  
  /**
   * 私有化构造函数，该类不允许实例化
   */
  private UnBusinessTableConst() {
    
  }

  /**
   * 判断表名是否是非业务表
   * @param tableName
   * @return
   */
  public static boolean isUnBusinessTable(String tableName){
    return UN_BUSINESS_TABLE.contains(tableName);
  }

}
