package com.bizunited.platform.core.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 纵向权限的操作符枚举
 * @Author: Paul Chan
 * @Date: 2020-04-23 17:46
 */
public enum AuthOperatorEnum {

  NEQ("!="),
  EQ("="),
  IN("IN"),
  NIN("NOT IN");

  private String oprtValue;

  AuthOperatorEnum(String oprtValue) {
    this.oprtValue = oprtValue;
  }

  public String getOprtValue() {
    return oprtValue;
  }

  public static String getOprtValue(String code) {
    for(AuthOperatorEnum element : AuthOperatorEnum.values()) {
      if(StringUtils.endsWithIgnoreCase(element.name(), code)) {
        return element.oprtValue;
      }
    }
    return null;
  }

}
