package com.bizunited.platform.core.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 *该工具类主要是动态调用服务源方法的责任链处理机制中，对前端传入的一些参数的简单分析
 *主要针对java八大基本类型数组（只支持到二维） 以及八大基础类型的解析
 */
public class ParamsAnalysisUtil {

  private ParamsAnalysisUtil(){}
  
  private static final String[] DATE_PATTERN = new String[]{"yyyy-MM-dd","yyyy-MM-dd HH:mm:ss"};


  /**
   * 二维数组的转化
   * 
   * @param source 需要转化的源数据
   * @param args 返回值是放入数组中的
   * @param index 返回值对应的下标
   * @param key 需要转为什么类型的数据
   * @return
   * 
   * 注：待转换元素中，如果有一个元素为空，那么转换后，默认为0或false
   */
  @SuppressWarnings("unchecked")
  public static Object[] unwapperArray2(Object source , Object[] args , int index , String key) {
    switch(key) {
      case "[[I" :
        ArrayList<ArrayList<Integer>> a = (ArrayList<ArrayList<Integer>>) source;
        int[][] ier = new int[a.size()][];
        for(int x = 0 ; x < a.size() ; x++) {
          if(a.get(x) != null) {
            ier[x] = new int[a.get(x).size()];
            for(int y = 0 ; y < a.get(x).size() && a.get(x).get(y) != null; y++) {
              ier[x][y] = a.get(x).get(y).intValue();
            }
          }else {
            ier[x] = new int[0];
          }
        }
        args[index] = ier;
        break;
        
      case "[[D" :
        ArrayList<ArrayList<Double>> b = (ArrayList<ArrayList<Double>>) source;
        double[][] der = new double[b.size()][];
        for(int x = 0 ; x < b.size() ; x++) {
          if(b.get(x) != null) {
            der[x] = new double[b.get(x).size()];
            for(int y = 0 ; y < b.get(x).size() && b.get(x).get(y) != null; y++) {
              der[x][y] = b.get(x).get(y).doubleValue();
            }
          }else {
            der[x] = new double[0];
          }
        }
        args[index] = der;
        break;
        
      case "[[J" :
        ArrayList<ArrayList<Long>> c = (ArrayList<ArrayList<Long>>) source;
        long[][] ler = new long[c.size()][];
        for(int x = 0 ; x < c.size() ; x++) {
          if(c.get(x) != null) {
            ler[x] = new long[c.get(x).size()];
            for(int y = 0 ; y < c.get(x).size() && c.get(x).get(y) != null; y++) {
              ler[x][y] = c.get(x).get(y).longValue();
            }
          }else {
            ler[x] = new long[0];
          }
        }
        args[index] = ler;
        break;
        
      case "[[S" :
        ArrayList<ArrayList<Short>> d = (ArrayList<ArrayList<Short>>) source;
        short[][] ser = new short[d.size()][];
        for(int x = 0 ; x < d.size() ; x++) {
          if(d.get(x) != null) {
            ser[x] = new short[d.get(x).size()];
            for(int y = 0 ; y < d.get(x).size() && d.get(x).get(y) != null; y++) {
              ser[x][y] = d.get(x).get(y).shortValue();
            }
          }else {
            ser[x] = new short[0];
          }
        }
        args[index] = ser;
        break;
        
      case "[[B" :
        ArrayList<ArrayList<Byte>> e = (ArrayList<ArrayList<Byte>>) source;
        byte[][] ber = new byte[e.size()][];
        for(int x = 0 ; x < e.size() ; x++) {
          if(e.get(x) != null) {
            ber[x] = new byte[e.get(x).size()];
            for(int y = 0 ; y < e.get(x).size() && e.get(x).get(y) != null; y++) {
              ber[x][y] = e.get(x).get(y).byteValue();
            }
          }else {
            ber[x] = new byte[0];
          }
        }
        args[index] = ber;
        break;
        
      case "[[Z" :
        ArrayList<ArrayList<Boolean>> f = (ArrayList<ArrayList<Boolean>>) source;
        boolean[][] zer = new boolean[f.size()][];
        for(int x = 0 ; x < f.size() ; x++) {
          if(f.get(x) != null) {
            zer[x] = new boolean[f.get(x).size()];
            for(int y = 0 ; y < f.get(x).size() && f.get(x).get(y) != null; y++) {
              zer[x][y] = f.get(x).get(y).booleanValue();
            }
          }else {
            zer[x] = new boolean[0];
          }
        }
        args[index] = zer;
        break;
        
      case "[[F" :
        ArrayList<ArrayList<Float>> g = (ArrayList<ArrayList<Float>>) source;
        float[][] fer = new float[g.size()][];
        for(int x = 0 ; x < g.size() ; x++) {
          if(g.get(x) != null) {
            fer[x] = new float[g.get(x).size()];
            for(int y = 0 ; y < g.get(x).size() && g.get(x).get(y) != null; y++) {
              fer[x][y] = g.get(x).get(y).floatValue();
            }
          }else {
            fer[x] = new float[0];
          }
        }
        args[index] = fer;
        break;
        
      case "[[C" :
        ArrayList<ArrayList<Character>> h = (ArrayList<ArrayList<Character>>) source;
        char[][] cer = new char[h.size()][];
        for(int x = 0 ; x < h.size() ; x++) {
          if(h.get(x) != null) {
            cer[x] = new char[h.get(x).size()];
            for(int y = 0 ; y < h.get(x).size() && h.get(x).get(y) != null; y++) {
              cer[x][y] = h.get(x).get(y).charValue();
            }
          }else {
            cer[x] = new char[0];
          }
        }
        args[index] = cer;
        break;
      default:
        return new Object[0];
    }
    return args;
  }
  
  
  /**
   * 数组的转化
   * 
   * @param source 需要转化的源数据
   * @param args 返回值是放入数组中的
   * @param index 返回值对应的下标
   * @param key 需要转为什么类型的数据
   * @return
   */
  @SuppressWarnings("unchecked")
  public static Object[] unwapperArray(Object source , Object[] args , int index , String key) {
    switch(key) {
      case "[I" :
        ArrayList<Integer> in = (ArrayList<Integer>) source;
        args[index] = in.stream().mapToInt(Integer::valueOf).toArray();
        break;
      case "[D" :
        ArrayList<Double> dou = (ArrayList<Double>) source;
        args[index] = dou.stream().mapToDouble(Double::valueOf).toArray();
        break;
      case "[J" :
        ArrayList<Long> lo = (ArrayList<Long>) source;
        args[index] = lo.stream().mapToLong(Long::valueOf).toArray();
        break;
      case "[S" :
        ArrayList<Short> a = (ArrayList<Short>)source;
        short[] b = new short[a.size()];
        for(int x = 0 ; x < a.size() ; x++) {
          b[x] = a.get(x).shortValue();
        }
        args[index] = b;
        break;
      case "[B" :
        ArrayList<Byte> a1 = (ArrayList<Byte>)source;
        byte[] b1 = new byte[a1.size()];
        for(int x = 0 ; x < a1.size() ; x++) {
          b1[x] = a1.get(x).byteValue();
        }
        args[index] = b1;
        break;
      case "[Z" :
        ArrayList<Boolean> a2 = (ArrayList<Boolean>)source;
        boolean[] b2 = new boolean[a2.size()];
        for(int x = 0 ; x < a2.size() ; x++) {
          b2[x] = a2.get(x).booleanValue();
        }
        args[index] = b2;
        break;
      case "[F" :
        ArrayList<Float> a3 = (ArrayList<Float>)source;
        float[] b3 = new float[a3.size()];
        for(int x = 0 ; x < a3.size() ; x++) {
          b3[x] = a3.get(x).floatValue();
        }
        args[index] = b3;
        break;
      case "[C" :
        ArrayList<Character> a4 = (ArrayList<Character>)source;
        float[] b4 = new float[a4.size()];
        for(int x = 0 ; x < a4.size() ; x++) {
          b4[x] = a4.get(x).charValue();
        }
        args[index] = b4;
        break;
      default:
        return new Object[0];
    }
    return args;
  }
  
  
  /**
   * 基本数据的转化
   * 
   * @param source 需要转化的源数据
   * @param args 返回值是放入数组中的
   * @param index 返回值对应的下标
   * @param key 需要转为什么类型的数据
   * @return
   */
  public static Object[] unwapper(Object source , Object[] args , int index , String key) {
    switch(key) {
      case "int" :
        args[index] = ((Number)source).intValue();
        break;
      case "double" :
        args[index] = ((Number)source).doubleValue();
        break;
      case "long" :
        args[index] = ((Number)source).longValue();
        break;
      case "short" :
        args[index] = ((Number)source).shortValue();
        break;
      case "byte" :
        args[index] = ((Number)source).byteValue();
        break;
      case "float" :
        args[index] = ((Number)source).floatValue();
        break;
      case "boolean" :
        args[index] = source;
        break;
      case "char" :
        args[index] = source;
        break;
      default:
        return new Object[0];
    }
    return args;
  }


  /**
   * 根据需要转换的类型，转换相应数据
   * @param obj
   * @param mappingType
   * @return
   */
  public static Object doTrans(Object obj , String mappingType) {
    if(obj == null) {
      return null;
    }

    if(StringUtils.isBlank(mappingType)){
      mappingType = obj.getClass().getName();
    }

    Object returnObj = null;
    
    boolean typeFlag = obj instanceof String;
    
    switch (mappingType) {
      case "java.lang.String":
        returnObj = String.valueOf(obj);
        break;
      case "java.util.Date"://与前端约定的，所有的时间传递，都是long类型的
        if(typeFlag) {
          try {
            //默认先匹配yyyy-MM-dd
            returnObj = DateUtils.parseDate(obj.toString(), DATE_PATTERN);
          } catch (ParseException e) {
            throw new IllegalArgumentException("传入参数不能转换为日期类型"+obj.toString()+"，请检查!!");
          }
        }else {
          Date d = new Date(Long.valueOf(obj.toString()));
          DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
          returnObj = df.format(d);
        }
        break;
      case "int":
      case "java.lang.Integer" :
        returnObj = typeFlag ? Integer.valueOf(obj.toString()) : ((Number) obj).intValue();
        break;
      case "double":
      case "java.lang.Double" :
        returnObj = typeFlag ? Double.valueOf(obj.toString()) : ((Number) obj).doubleValue();
        break;
      case "float":
      case "java.lang.Float":
        returnObj = typeFlag ? Float.valueOf(obj.toString()) : ((Number) obj).floatValue();
        break;
      case "long":
      case "java.lang.Long":
        returnObj = typeFlag ? Long.valueOf(obj.toString()) : ((Number) obj).longValue();
        break;
      case "short":
      case "java.lang.Short":
        returnObj = typeFlag ? Short.valueOf(obj.toString()) : ((Number) obj).shortValue();
        break;
      case "byte":
      case "java.lang.Byte":
        returnObj = typeFlag ? Byte.valueOf(obj.toString()) : ((Number) obj).byteValue();
        break;
      case "boolean":
      case "java.lang.Boolean":
        returnObj = typeFlag ? Boolean.valueOf(obj.toString()) : ((Boolean)obj).booleanValue();
        break;
      case "char":
      case "java.lang.Character":
        returnObj = obj;
        break;
      default :
        returnObj = obj;
        break;
    }
    return returnObj;
  }

}
