package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.dataview.ExcelExportTemplate;
import com.bizunited.platform.core.service.dataview.internal.DefaultExcelExportTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 数据视图的配置
 * @Author: Paul Chan
 * @Date: 2020-03-17 21:05
 */
@Configuration
public class DataViewConfig {

  @Bean
  @ConditionalOnMissingBean(ExcelExportTemplate.class)
  public ExcelExportTemplate getExcelExportTemplate() {
    return new DefaultExcelExportTemplate();
  }

}
