package com.bizunited.platform.core.configuration;

import org.redisson.spring.session.config.EnableRedissonHttpSession;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

/**
 * 技术中台“底座”模块主配置过程
 *
 * @author yinwenjie
 */
@Configuration
//启动缓存
@EnableCaching
//启动spring session
@EnableRedissonHttpSession(keyPrefix = "spring:session:sessions:")
@EntityScan(basePackages = "com.bizunited.platform.core.entity")
@EnableJpaRepositories(basePackages = "com.bizunited.platform.core.repository")
@ComponentScan(basePackages = {"com.bizunited.platform.core", "com.bizunited.platform.rbac.server", "com.bizunited.platform.common"})
public class PlatformCoreConfig {

}