package com.bizunited.platform.core.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.log.LoggerTemplateEntity;
import com.bizunited.platform.core.service.LoggerTemplateEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * LoggerTemplateEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/loggerTemplateEntitys")
public class LoggerTemplateEntityController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(LoggerTemplateEntityController.class);
  
  @Autowired
  private LoggerTemplateEntityService loggerTemplateEntityService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建loggerTemplateEntity中的基本信息以外，还可以对loggerTemplateEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（LoggerTemplateEntity）模型的创建操作传入的loggerTemplateEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建loggerTemplateEntity中的基本信息以外，还可以对loggerTemplateEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（LoggerTemplateEntity）模型的创建操作传入的loggerTemplateEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="loggerTemplateEntity" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建loggerTemplateEntity中的基本信息以外，还可以对loggerTemplateEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（LoggerTemplateEntity）模型的创建操作传入的loggerTemplateEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") LoggerTemplateEntity loggerTemplateEntity) {
    try {
      LoggerTemplateEntity current = this.loggerTemplateEntityService.create(loggerTemplateEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（LoggerTemplateEntity）的修改操作传入的loggerTemplateEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（LoggerTemplateEntity）的修改操作传入的loggerTemplateEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="loggerTemplateEntity" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（LoggerTemplateEntity）的修改操作传入的loggerTemplateEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") LoggerTemplateEntity loggerTemplateEntity) {
    try {
      LoggerTemplateEntity current = this.loggerTemplateEntityService.update(loggerTemplateEntity);
      current.setModifyTime(new Date());
      current.setModifyAccount(SecurityUtils.getUserAccount());
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照LoggerTemplateEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照LoggerTemplateEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      LoggerTemplateEntity result = this.loggerTemplateEntityService.findDetailsById(id);
      return this.buildHttpResultW(result, new String[]{"createUser","modifyUser"});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }
  /**
   * 按照LoggerTemplateEntity实体中的（code）模板编号，唯一的编号，必须有进行查询
   * @param code 模板编号，唯一的编号，必须有
   */
  @ApiOperation(value = "按照LoggerTemplateEntity实体中的（code）模板编号，唯一的编号，必须有进行查询")
  @RequestMapping(value="/findByCode" , method={RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("模板编号，唯一的编号，必须有") String code) {
    try { 
      LoggerTemplateEntity result = this.loggerTemplateEntityService.findByCode(code);
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照LoggerTemplateEntity实体中的（methodName）完整的被拦截的方法名进行查询
   * @param methodName 完整的被拦截的方法名
   */
  @ApiOperation(value = "按照LoggerTemplateEntity实体中的（methodName）完整的被拦截的方法名进行查询")
  @RequestMapping(value="/findByMethodName" , method={RequestMethod.GET})
  public ResponseModel findByMethodName(@RequestParam("methodName") @ApiParam("完整的被拦截的方法名") String methodName) {
    try { 
      LoggerTemplateEntity result = this.loggerTemplateEntityService.findByMethodName(methodName);
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 按照LoggerTemplateEntity实体中的中的 (formInstanceId、code、name、methodName、state)进行分页查询
   * @param loggerTemplateEntity 日志模板实体
   */
  @ApiOperation(value = "按照LoggerTemplateEntity实体中的（formInstanceId、code、name、methodName、state）进行分页查询")
  @RequestMapping(value="/findByConditions" , method={RequestMethod.GET})
  public ResponseModel findByConditions( @ApiParam("日志模板实体") LoggerTemplateEntity loggerTemplateEntity,
                                        @PageableDefault(value = 50) @ApiParam("分页参数，当指定page时为查询当前页码（页码从0开始）；当指定size时，为指定每页大小，默认为50") Pageable pageable) {
    try {
      Page<LoggerTemplateEntity> result = this.loggerTemplateEntityService.findByConditions(loggerTemplateEntity,pageable);
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

} 
