package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * DataViewAuthHorizontalEntity  数据视图横向权限
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dataViewAuthHorizontals")
public class DataViewAuthHorizontalController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthHorizontalController.class);

  @Autowired
  private DataViewAuthHorizontalService dataViewAuthHorizontalService;

  /**
   * 保存横向数据权限
   * @param authId
   * @param horizontals
   * @return
   */
  @PostMapping("")
  @ApiOperation("保存横向数据权限")
  public ResponseModel save(@RequestParam @ApiParam("权限ID") String authId,
                            @RequestBody @ApiParam("横向权限数据") Set<DataViewAuthHorizontalEntity> horizontals) {
    try {
      Set<DataViewAuthHorizontalEntity> authHorizontals = dataViewAuthHorizontalService.save(authId, horizontals);
      return buildHttpResultW(authHorizontals, "dataViewAuth", "authRelations");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

} 
