package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthInterceptorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * 数据视图权限拦截器控制器，restfull风格接口
 * @Author: Paul Chan
 * @Date: 2019-12-23 10:25
 */
@RestController
@Api(tags = "数据视图权限拦截器控制器")
@RequestMapping("/v1/nebula/dataViewAuthInterceptors")
public class DataViewAuthInterceptorController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthInterceptorController.class);

  @Autowired
  private DataViewAuthInterceptorService dataViewAuthInterceptorService;

  /**
   * 保存权限拦截器
   * @param authId
   * @param interceptors
   * @return
   */
  @PostMapping("")
  @ApiOperation("新增数据视图权限拦截器")
  public ResponseModel save(@RequestParam @ApiParam("权限ID") String authId,
                              @RequestBody @ApiParam("拦截器信息") Set<DataViewAuthInterceptorEntity> interceptors) {
    try {
      Set<DataViewAuthInterceptorEntity> authInterceptors = dataViewAuthInterceptorService.save(authId, interceptors);
      return buildHttpResultW(authInterceptors);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 查询数据视图权限拦截器
   * @return
   */
  @GetMapping("findAll")
  @ApiOperation("查询数据视图权限拦截器")
  public ResponseModel findAll() {
    try {
      List<String> authInterceptors = dataViewAuthInterceptorService.findAll();
      return buildHttpResult(authInterceptors);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }
}
