package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * DataViewAuthVerticalEntity 数据视图纵向权限
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dataViewVerticals")
public class DataViewAuthVerticalController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthVerticalController.class);
  
  @Autowired
  private DataViewAuthVerticalService dataViewAuthVerticalService;

  /**
   * 保存纵向权限
   * @param authId
   * @param authVerticals
   * @return
   */
  @PostMapping("")
  @ApiOperation("保存纵向权限")
  public ResponseModel save(@RequestParam @ApiParam("权限ID") String authId,
                            @RequestBody @ApiParam("纵向权限") Set<DataViewAuthVerticalEntity> authVerticals) {
    try {
      Set<DataViewAuthVerticalEntity> verticals = dataViewAuthVerticalService.save(authId, authVerticals);
      return buildHttpResultW(verticals, "dataViewAuth", "authRelations", "authRelations.relation");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

} 
