package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * DataViewFieldEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dataViewFields")
public class DataViewFieldController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewFieldController.class);
  
  @Autowired
  private DataViewFieldService dataViewFieldEntityService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建dataViewFieldEntity中的基本信息以外，还可以对dataViewFieldEntity中属于OneToMany关联的明细信息一同进行创建注意：创建操作传入的dataViewFieldEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建dataViewFieldEntity中的基本信息以外，还可以对dataViewFieldEntity中属于OneToMany关联的明细信息一同进行创建注意：创建操作传入的dataViewFieldEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="dataViewFieldEntity" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建dataViewFieldEntity中的基本信息以外，还可以对dataViewFieldEntity中属于OneToMany关联的明细信息一同进行创建注意：创建操作传入的dataViewFieldEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") DataViewFieldEntity dataViewFieldEntity) {
    try {
      DataViewFieldEntity current = this.dataViewFieldEntityService.create(dataViewFieldEntity , false);
      return this.buildHttpResultW(current);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：修改操作传入的dataViewFieldEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：修改操作传入的dataViewFieldEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="dataViewFieldEntity" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：修改操作传入的dataViewFieldEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") DataViewFieldEntity dataViewFieldEntity) {
    try {
      DataViewFieldEntity current = this.dataViewFieldEntityService.update(dataViewFieldEntity);
      return this.buildHttpResultW(current);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照对应的视图查询DataViewFieldEntity
   */
  @ApiOperation(value = "按照对应的视图查询DataViewFieldEntity")
  @RequestMapping(value="/findByDataView" , method={RequestMethod.GET})
  public ResponseModel findByDataView(@RequestParam("dataViewId") @ApiParam("对应的视图") String dataViewId) {
    try {
      List<DataViewFieldEntity> result = this.dataViewFieldEntityService.findByDataView(dataViewId);
      return this.buildHttpResultW(result, "dataView");
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  } 
  /**
   * 按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      DataViewFieldEntity result = this.dataViewFieldEntityService.findDetailsById(id); 
      return this.buildHttpResultW(result, "dataView");
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 按照对应的视图查询设定了权限信息的DataViewFieldEntity
   */
  @ApiOperation(value = "按照对应的视图查询设定了权限信息的DataViewFieldEntity")
  @RequestMapping(value="/findAuthTypeFieldsByDataView" , method={RequestMethod.GET})
  public ResponseModel findAuthTypeFieldsByDataView(@RequestParam("dataViewId") @ApiParam("对应的视图") String dataViewId) {
    try {
      Set<DataViewFieldEntity> result = this.dataViewFieldEntityService.findAuthTypeFieldsByDataView(dataViewId);
      return this.buildHttpResultW(result);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

}
