package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 数据视图绑定的数据库源描述
 * @author yinwenjie
 */
@Entity
@Table(name="engine_datasource")
@org.hibernate.annotations.Table(appliesTo = "engine_datasource" , comment = "数据视图绑定的数据库源描述")
public class DataSourceEntity extends UuidEntity {
  private static final long serialVersionUID = 8891191999019388557L;
  /**
   * 数据库编号
   */
  @Column(name="code" , length=64 , nullable=false , unique=true, columnDefinition = "varchar(64) COMMENT '数据库编号'")
  @SaturnColumn(description="数据库编号")
  private String code;
  /**
   * 数据库类型：目前支持两种MYSQL/ORACLE
   */
  @Column(name="type" , length=32 , nullable=false, columnDefinition = "varchar(32) COMMENT '数据库类型：目前支持两种MYSQL/ORACLE'")
  @SaturnColumn(description="数据库类型")
  private String type;
  /**
   * 连接地址IP或者域名
   */
  @Column(name="address" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '连接地址IP或者域名'")
  @SaturnColumn(description="连接地址")
  private String address;
  /**
   * 数据库连接端口
   */
  @Column(name="port" , nullable=false, columnDefinition = "int(11) COMMENT '数据库连接端口'")
  @SaturnColumn(description="连接端口")
  private Integer port;
  /**
   * 数据库登录用户名
   */
  @Column(name="username" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '数据库登录用户名'")
  @SaturnColumn(description="登录用户名")
  private String userName;
  /**
   * 数据库登录密码（双向加密后的）
   */
  @Column(name="password" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '数据库登录密码（双向加密后的）'")
  @SaturnColumn(description="数据库密码")
  private String password;
  /**
   * 数据库名
   */
  @Column(name="dbname" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '数据库名'")
  @SaturnColumn(description="数据库名")
  private String dbName;
  /**
   * 创建时间
   */
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime;
  /**
   * 数据库连接状态信息<br>
   * 1：正常（启用）；0：禁用（未启动）
   */
  @Column(name="t_status" , nullable=false, columnDefinition = "int(11) COMMENT '数据库连接状态信息：1：正常（启用）；0：禁用（未启动）'")
  @SaturnColumn(description="连接状态")
  private Integer tstatus = 1;
  /**
   * 操作参数信息
   */
  @Column(name="url_params" , nullable=false, columnDefinition = "varchar(255) COMMENT '操作参数信息'")
  @SaturnColumn(description="操作参数信息")
  private String urlParams = "";
  /**
   * 项目名
   */
  @ApiModelProperty("项目名")
  @SaturnColumn(description = "项目名")
  @Column(name = "project_name", length = 128, columnDefinition = "varchar(128) default '' COMMENT '项目名'")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }
  public String getAddress() {
    return address;
  }
  public void setAddress(String address) {
    this.address = address;
  }
  public String getUserName() {
    return userName;
  }
  public void setUserName(String userName) {
    this.userName = userName;
  }
  public String getPassword() {
    return password;
  }
  public void setPassword(String password) {
    this.password = password;
  }
  public String getDbName() {
    return dbName;
  }
  public void setDbName(String dbName) {
    this.dbName = dbName;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public String getUrlParams() {
    return urlParams;
  }
  public void setUrlParams(String urlParams) {
    this.urlParams = urlParams;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Integer getPort() {
    return port;
  }
  public void setPort(Integer port) {
    this.port = port;
  }
}
