package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-15 09:59
 * @Description: 动态模板数据表，该功能点的具体要求请参见线框图中的详细设计说明
 */
@ApiModel("动态模板数据表，该功能点的具体要求请参见线框图中的详细设计说明")
@Entity
@Table(name="engine_datasource_table")
@org.hibernate.annotations.Table(appliesTo = "engine_datasource_table" , comment = "动态模板数据表")
public class DataSourceTableEntity extends UuidEntity {

  private static final long serialVersionUID = 981572749734062061L;
  /**
   * 数据源信息
   */
  @ManyToOne(fetch= FetchType.LAZY , targetEntity = DataSourceEntity.class)
  @JoinColumn(name="data_source", columnDefinition = "varchar(255) COMMENT '数据源信息'")
  @SaturnColumn(description="数据源信息")
  private DataSourceEntity dataSource;
  /**
   * 数据表名
   */
  @ApiModelProperty(name = "tableName", value = "数据表名")
  @Column(name = "table_name", nullable = false, columnDefinition = "varchar(255) COMMENT '数据表名'")
  @SaturnColumn(description = "数据表名")
  private String tableName;
  /**
   * 数据表说明
   */
  @ApiModelProperty(name = "tableDesc", value = "数据表说明")
  @Column(name = "table_desc", columnDefinition = "varchar(255) COMMENT '数据表说明'")
  @SaturnColumn(description = "数据表说明")
  private String tableDesc;
  /**
   * 数据表性质 0:非业务表, 1:业务表
   */
  @ApiModelProperty(name = "tableType", value = "数据表性质 0:非业务表, 1:业务表")
  @Column(name = "table_type", nullable = false, columnDefinition = "int(11) COMMENT '数据表性质 0:非业务表, 1:业务表'")
  @SaturnColumn(description = "数据表性质")
  private Integer tableType;
  /**
   * 数据表状态
   */
  @ApiModelProperty(name = "tStatus", value = "数据表状态 0:禁用, 1:启用")
  @Column(name = "t_status", nullable = false, columnDefinition = "int(11) COMMENT '数据表状态 0:禁用, 1:启用'")
  @SaturnColumn(description = "数据表状态")
  private Integer tStatus;
  /**
   * 数据表的创建时间
   */
  @ApiModelProperty(name = "createTime", value = "数据表的创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '数据表的创建时间'")
  @SaturnColumn(description = "数据表的创建时间")
  private Date createTime;
  /**
   * 数据表的最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "数据表的最后修改时间")
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '数据表的最后修改时间'")
  @SaturnColumn(description = "数据表的最后修改时间")
  private Date modifyTime;

  public DataSourceEntity getDataSource() {
    return dataSource;
  }
  public void setDataSource(DataSourceEntity dataSource) {
    this.dataSource = dataSource;
  }

  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  public String getTableDesc() {
    return tableDesc;
  }

  public void setTableDesc(String tableDesc) {
    this.tableDesc = tableDesc;
  }

  public Integer getTableType() {
    return tableType;
  }

  public void setTableType(Integer tableType) {
    this.tableType = tableType;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public Integer gettStatus() {
    return tStatus;
  }

  public void settStatus(Integer tStatus) {
    this.tStatus = tStatus;
  }
}
