package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import org.hibernate.annotations.OrderBy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * 数据视图之纵向数据权限信息
 */
@Entity
@Table(name="engine_dataview_auth_vertical")
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_auth_vertical" , comment = "数据视图之纵向数据权限信息")
public class DataViewAuthVerticalEntity extends UuidEntity {
  private static final long serialVersionUID = 4306054657534697494L;

  /**
   * 数据视图权限
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="dataview_auth_id" , nullable=false , columnDefinition = "varchar(255) COMMENT '数据视图权限'")
  @SaturnColumn(description="数据视图权限")
  private DataViewAuthEntity dataViewAuth;

  /**
   * 权限类型
   * 1、用户
   * 2.角色
   * 3.岗位
   * 4.用户组
   * 5.组织机构
   */
  @Column(name="auth_type" , nullable=false , columnDefinition = "int(11) COMMENT '权限类型 1、用户 2.角色 3.岗位 4.用户组 5.组织机构'")
  @SaturnColumn(description="权限类型")
  private Integer authType;
  /**
   * 操作符类型
   */
  @Column(name="oprt_type" , length=32,nullable=false , columnDefinition = "varchar(32) COMMENT '操作符类型'" )
  @SaturnColumn(description="操作符类型")
  private String oprtType;

  /**
   * 需要显示的字段集,多字段以逗号（,）隔开
   */
  @Column(name="display_fields" , nullable=false , columnDefinition = "varchar(500) COMMENT '需要显示的字段集,多字段以逗号（,）隔开'")
  @SaturnColumn(description="需要显示的字段集,多字段以逗号（,）隔开")
  private String displayFields;
  /**
   * 纵向数据权限信息指定的权限领域
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="authVertical")
  @SaturnColumn(description="权限领域")
  @OrderBy(clause = "sortIndex")
  private Set<DataViewAuthVerticalRelationEntity> authRelations;

  /**
   * 排序字段
   */
  @Column(name="sort_index" , nullable=false , columnDefinition = "int(11) COMMENT '排序字段'")
  @SaturnColumn(description="纵向数据权限排序")
  private Integer sortIndex;

  public Integer getAuthType() {
    return authType;
  }

  public void setAuthType(Integer authType) {
    this.authType = authType;
  }

  public Set<DataViewAuthVerticalRelationEntity> getAuthRelations() {
    return authRelations;
  }

  public void setAuthRelations(Set<DataViewAuthVerticalRelationEntity> authRelations) {
    this.authRelations = authRelations;
  }

  public String getOprtType() {
    return oprtType;
  }

  public void setOprtType(String oprtType) {
    this.oprtType = oprtType;
  }


  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public DataViewAuthEntity getDataViewAuth() {
    return dataViewAuth;
  }

  public void setDataViewAuth(DataViewAuthEntity dataViewAuth) {
    this.dataViewAuth = dataViewAuth;
  }

  public String getDisplayFields() {
    return displayFields;
  }

  public void setDisplayFields(String displayFields) {
    this.displayFields = displayFields;
  }
}
