package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 数据视图中对应的结构字段信息
 * @author yinwenjie
 */
@Entity
@Table(name="engine_dataview_field" , indexes={@Index(columnList="data_view,field_name" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_field" , comment = "数据视图中对应的结构字段信息")
public class DataViewFieldEntity extends UuidEntity {
  private static final long serialVersionUID = 2147614738355767477L;
  /**
   * 对应的视图
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="data_view" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应的视图'")
  @SaturnColumn(description="对应的视图")
  private DataViewEntity dataView;


  /**
   * UUID 唯一编码（后续数据视图迁移用）
   */
  @Column(name="code" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '唯一编码（后续数据视图迁移用）'")
  @SaturnColumn(description="UUID 唯一编码（后续数据视图迁移用）")
  private String code;


  /**
   * 视图输出的字段名（英文）
   */
  @Column(name="field_name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '视图输出的字段名（英文）'")
  @SaturnColumn(description="字段名（英文）")
  private String fieldName;
  /**
   * 显示中文名
   */
  @Column(name = "display_name",length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '显示中文名'")
  @SaturnColumn(description = "显示中文名")
  private String displayName;

  /**
   * 字段类型（Java类型）
   */
  @Column(name="field_type" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '字段类型'")
  @SaturnColumn(description="字段类型")
  private String fieldType;
  /**
   * 字段排序
   */
  @Column(name="sort_index" ,  nullable=false, columnDefinition = "int(11) COMMENT '字段排序'")
  @SaturnColumn(description="字段排序")
  private Integer sortIndex = 1;
  /**
   * 是否物理数据表中的字段
   */
  @Column(name="physical" ,  nullable=false, columnDefinition = "bit(1) COMMENT '是否物理字段'")
  @SaturnColumn(description="是否物理字段")
  private Boolean physical = true;
  /**
   * 可能所属的数据分库
   */
  @Column(name="schema_name" , length=64 , nullable=true, columnDefinition = "varchar(64) COMMENT '可能所属的数据分库'")
  @SaturnColumn(description="数据分库")
  private String schemaName = "";
  /**
   * 可能所属的物理数据表
   */
  @Column(name="target_table" , length=64 , nullable=true, columnDefinition = "varchar(64) COMMENT '可能所属的物理数据表'")
  @SaturnColumn(description="物理数据表")
  private String targetTable = "";
  /**
   * 可能所属的物理数据表字段
   */
  @Column(name="target_field" , length=64 , nullable=true, columnDefinition = "varchar(64) COMMENT '可能所属的物理数据表字段'")
  @SaturnColumn(description="物理字段")
  private String targetField = "";
  /**
   * 是否依然有效</br>
   * 当更新视图时，有一些字段会自动变为无效
   * 其关联的显示、排序、条件信息也都将变成无效
   */
  @Column(name="t_status" , nullable=false, columnDefinition = "int(11) COMMENT '是否依然有效 当更新视图时，有一些字段会自动变为无效其关联的显示、排序、条件信息也都将变成无效'")
  @SaturnColumn(description="是否有效")
  private Integer tstatus = 1;
  
  /**
   * 数据视图支持的字典code
   * 前端用于记录视图中绑定的字典code值
   */
  @Column(name="dict_code " , nullable=true, columnDefinition = "varchar(255) COMMENT '数据视图支持的字典code,前端用于记录视图中绑定的字典code值'")
  @SaturnColumn(description="数据视图支持的字典code")
  private String enumsource;
  /**
   * 设定的权限类型
   * 1、用户
   * 2、角色
   * 3、岗位
   * 4、用户组
   * 5、组织机构
   */
  @Column(name="auth_type" , nullable=true, columnDefinition = "int(11) COMMENT '设定的权限类型 1、用户 2、角色 3、岗位 4、用户组 5、组织机构 '")
  @SaturnColumn(description="设定的权限类型")
  private Integer authType;
  
  public DataViewEntity getDataView() {
    return dataView;
  }
  public void setDataView(DataViewEntity dataView) {
    this.dataView = dataView;
  }
  public String getFieldName() {
    return fieldName;
  }
  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }
  public String getFieldType() {
    return fieldType;
  }
  public void setFieldType(String fieldType) {
    this.fieldType = fieldType;
  }
  public Integer getSortIndex() {
    return sortIndex;
  }
  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
  public Boolean getPhysical() {
    return physical;
  }
  public void setPhysical(Boolean physical) {
    this.physical = physical;
  }
  public String getSchemaName() {
    return schemaName;
  }
  public void setSchemaName(String schemaName) {
    this.schemaName = schemaName;
  }
  public String getTargetTable() {
    return targetTable;
  }
  public void setTargetTable(String targetTable) {
    this.targetTable = targetTable;
  }
  public String getTargetField() {
    return targetField;
  }
  public void setTargetField(String targetField) {
    this.targetField = targetField;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }
  public String getEnumsource() {
    return enumsource;
  }
  public void setEnumsource(String enumsource) {
    this.enumsource = enumsource;
  }

  public Integer getAuthType() {
    return authType;
  }

  public void setAuthType(Integer authType) {
    this.authType = authType;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }
}
